/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class UpgradeManager
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(UpgradeManager.class);
    protected static final String CURRENT_INSTALLED_BUILD_KEY = "com.comalatech.adhoccanvas.currentbuild";
    protected static final String PREVIOUS_INSTALL_KEY_PREFIX = "com.comalatech.adhoccanvas.installhistory.";
    protected static final int BUILD_NUMBER = 401;
    private final BandanaManager bandanaManager;

    public UpgradeManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    public void afterPropertiesSet() throws Exception {
        int previousBuildNumber = this.getCurrentBuildNumber();
        if (previousBuildNumber != 401) {
            this.setCurrentBuildNumber(401);
            this.setInstallHistory(401);
            log.info("Comala Canvas updated to build: 401");
        }
    }

    protected void setCurrentBuildNumber(int buildNumber) {
        this.bandanaManager.setValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, CURRENT_INSTALLED_BUILD_KEY, (Object)(buildNumber + ""));
    }

    protected int getCurrentBuildNumber() {
        Object obj = this.bandanaManager.getValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, CURRENT_INSTALLED_BUILD_KEY);
        if (obj != null) {
            try {
                return Integer.parseInt((String)obj);
            }
            catch (NumberFormatException nfe) {
                log.error("Error parsing saved canvas build number", (Throwable)nfe);
            }
        }
        return -1;
    }

    protected void setInstallHistory(int buildNumber) {
        Object obj = this.bandanaManager.getValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, PREVIOUS_INSTALL_KEY_PREFIX + buildNumber);
        if (obj == null) {
            this.bandanaManager.setValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, PREVIOUS_INSTALL_KEY_PREFIX + buildNumber, (Object)(new Date().getTime() + ""));
        }
    }
}

