/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

Canvas = Canvas || {};
Canvas.View = Canvas.View || {};
Canvas.View.ConfigurePanel = Backbone.View.extend({

    model: Canvas.Model.Table,
    className: "dialog-panel-body panel-body configure hidden",
    template: Canvas.Picker.configureTabs,

    render: function() {
        this.$el.html(this.template());
        var propertiesDialog = new Canvas.View.BoardPropertiesDialog({model: this.model.get("board")});
        this.$("#properties").html(propertiesDialog.render().el);
        var filterDialog = new Canvas.View.FilterDialog({model: this.model.get("filter")});
        this.$("#filter").html(filterDialog.render().el);
        return this;
    }

});
