/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

(function ($) {

    var popupWelcome = function (iFrameUrl, renderDontShowAgain) {
        try {
            var popup = new AJS.Dialog(847, 540);
            popup.addHeader("Welcome to Comala Canvas!");
            var iframe = "<iframe src=' " + iFrameUrl + "' width='99%' height='99%' frameborder='0' scrolling='no'/>"
            var checkbox =  "<div class='checkbox' style='float: left; padding-left: 30px;'>" +
                    "<input name='adhoccanvaswelcome-hide' id='adhoccanvaswelcome-hide' type='checkbox'>" +
                    "<label for='adhoccanvaswelcome-hide'>Don't show this again</label>" +
                "</div>";
            popup.addPanel("Welcome", iframe, "panel1" );
            popup.addButton("Close", function (dialog) {
                if ( $("#adhoccanvaswelcome-hide:checked").length > 0 ){
                    rememberHideWelcomeForUser();
                }
                dialog.remove();
            });

            popup.show();
            if ( renderDontShowAgain ){
                $(".dialog-button-panel").append( checkbox );
            }
            createCookie("com.comalatech.adhoccanvas.welcome.shown", true, 1);
        } catch (e) {
            AJS.log(e);
        }
    };

    var createCookie = function(name, value, days) {
        var expires;
        if (days) {
            var date = new Date();
            date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
            expires = "; expires=" + date.toGMTString();
        } else {
            expires = "";
        }
        document.cookie = name + "=" + value + expires + "; path=/";
    };

    var readCookie = function(name) {
        var nameEQ = name + "=";
        var ca = document.cookie.split(';');
        for (var i = 0; i < ca.length; i++) {
            var c = ca[i];
            while (c.charAt(0) == ' ') c = c.substring(1, c.length);
            if (c.indexOf(nameEQ) == 0)
                return c.substring(nameEQ.length, c.length);
        }
        return null;
    };

    var eraseCookie = function(name) {
        createCookie(name, "", -1);
    };

    var rememberHideWelcomeForUser = function() {
        createCookie("com.comalatech.adhoccanvas.welcome.shown", true, 1000);
        $.ajax({
            type: "POST",
            cache: false,
            url: AJS.Confluence.getContextPath() + "/rest/adhoclists/latest/welcome/hide"
        });
    };

    AJS.toInit(function ($) {
        $(document).on('click', ".options-help a", function(event) {
            event.preventDefault();
            var url = $(this).attr("href");
            popupWelcome( url, false );
            return false;
        });
        
        // (Mike) observation: Not really a good practice to wrap an entire fragment of code in a try-catch
        try {
            $(document).on('click', ".adhochelp span", function(event) {
                event.preventDefault();
                var url = $(this).attr("url");
                popupWelcome( url, false );
            });
            $(document).on('click', "#introducing-adhoccanvas span", function(event) {
                event.preventDefault();
                var url = $(this).parents("a").attr("href");
                popupWelcome( url, false );
            });
            var showWelcome;
            if ($("#adhoccanvaswelcome").length > 0) {
                showWelcome = $("#adhoccanvaswelcome").val() == "true";
            } else {
                var adminWelcomeUrl = $('meta[name=adhoccanvas-welcome]').attr('content');
                showWelcome = adminWelcomeUrl != undefined;
            }
            var isCookieShown = readCookie("com.comalatech.adhoccanvas.welcome.shown");
            if ( showWelcome && !isCookieShown ){
                var url = adminWelcomeUrl || $("#adhoccanvaswelcome-url").val();
                popupWelcome( url, true);
            }
        } catch (e) {
            AJS.log(e);
        }
    });
})(AJS.$);