/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

(function ($) {
    if (Canvas.initialized("wikiinput.column")) {
        return;
    }

    AJS.toInit(function ($) {
        AJS.log("init wikiinput.column");
        // Saving column
        $(document).on('click', "form.aui.checklist.column.wikiinput .accept", function(event) {
            event.preventDefault();
            var $form = $(this).parents("form.aui.checklist");
            var columnInfo = $form.getColumnInfo();
            columnInfo.setAttributes($form);
            columnInfo.resetHeading();
            // let's set the column's specific properties
            var valueName = columnInfo.column[columnInfo.type].header;
            var rows = $("#rows").val();
            var inputwidth = $("#inputWidth").val();
            var readonly = $("#readonly:checked").val();
            var column = columnInfo.column[columnInfo.type];
            column.readOnly = typeof readonly != 'undefined' ;
            column.rows = rows;
            column.inputWidth = inputwidth;
            column.valueName = valueName;

            Adhoc.debug = columnInfo;
            Adhoc.Checklist.columnDialog.hide();
            Adhoc.Checklist.refresh();
        });
    });
})(AJS.$);