/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var requirejs = require || requirejs; 

requirejs(['jquery', 'ajs', 'confluence/root'], function ($, AJS, ConfluenceRoot) {
    var Adhoc = Adhoc || {};
    Adhoc.hasQuery = location.href.indexOf('?') + 1;
    Adhoc.queryString = Adhoc.hasQuery ? location.href.substr(Adhoc.hasQuery) : '';

    Adhoc.isBoardTemplate = (AJS.getWindowQueryParams().boardTemplate === "true");

    function loadPage() {
        console.log("init ad hoc boards createpage from template.");

        if (Adhoc.isBoardTemplate) {
            $("#header").hide();
            $("#rte-button-preview").hide();
            $("#rte-savebar").find(".toolbar-split-left").hide();

            var labelsString = AJS.getWindowQueryParams.createPageLabelsString || "";

            if (labelsString.length > 0) {
                $("#createpageform").find("#createPageLabelsString").val(labelsString);
            }

            ConfluenceRoot.Editor.addSaveHandler(function () {
                var title = $("#content-title").val();
                window.opener.$('body').trigger('boardTemplate.savePage', [title]); // send the final page title as event data
                $("body").fadeOut();
            });
        }
    };

    AJS.toInit(function () {
        if ($('#rte').is(':visible')) {
            loadPage();
        } else {
            AJS.bind("init.rte", function (ev) {
                console.log("AHP init.rte", ev);
                if ($('#comments-section').size() === 0) { // only load for page edit, not for comments
                    loadPage();
                }
            });
        }
    });
});
