/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

(function ($) {
    var IFRAME_ID = 'cnv-getting-started-iframe';


    var showGettingStartedDialog = function () {

        var theDialog = new AJS.Dialog({
                    "width": 860,
                    "height": 550,
                    "id": "cnv-getting-started-dialog",
                    closeOnOutsideClick: true
                });
        theDialog.addHeader(AJS.I18n.getText("adhoccanvas.upm.gettingstarted.header"));
        theDialog.addPanel("",'<iframe id="cnv-getting-started-iframe" src="https://apps.appf.re/cbdc/doc/getstarted/OxqkF0" width="99%" height="99%" frameborder="0" scrolling="no"></iframe>',"cnv-gettingstarted-panel");
        theDialog.addLink(AJS.I18n.getText("adhoclists.close"), function (dialog) {
            dialog.hide();
        }, "#");

        theDialog.gotoPage(0);
        theDialog.show();
    }

    if (upm) {
        // For the "Get Started" button
        $(document).on('detailsLoaded', "div.upm-details", function(ev) {
            if (upm.createHash) { //Some older versions of the UPM don't have this. The Get started buttons don't seem to exist in these UPM versions anyway.
                $("#upm-plugin-" + upm.createHash("com.comalatech.adhoccanvas", "manage") + " .upm-get-started").unbind("click").click(function(ev) {
                    showGettingStartedDialog();
                    return false;
                });
            }
        });

        var isCanvasRelated = function (pluginStatusDialog){
            return pluginStatusDialog.id === "upm-plugin-status-dialog" &&
                $(".plugin-name-version .plugin-name", pluginStatusDialog.getPage(0).body).text() === "Comala Canvas";
        };

        var defaultUpmStatusDialog = upm.showPluginStatusDialog;
        upm.showPluginStatusDialog = function(heading, pluginElement, body, button, buttonHandler, htmlBody) {
            defaultUpmStatusDialog(
                heading,
                pluginElement,
                body,
                button,
                (function() {
                    return function(upmStatusDialog) {
                        if (isCanvasRelated(upmStatusDialog)) {
                            upmStatusDialog.remove();
                            showGettingStartedDialog();
                            return false;
                        } else if (buttonHandler) {
                            buttonHandler(upmStatusDialog);
                        }
                    }
                })(),
                htmlBody
            );
        };

    }

})(AJS.$);
