/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var requirejs = require || requirejs;

requirejs(['cb', 'jquery'], function (CB, $) {
    CB.toInit(function () {
        // Render list of boards
        var $target = $('#cb-board-collection');
        var boards = $target.data('cbBoards');
        var spaceKey = CB.getParam('spaceKey');
        var customData = { boards: boards };
        var boardIframe = new CB.iframe({
            id: 'cb-coabrd-collection-iframe',
            url: '/boards/collection/' + spaceKey,
            height: '100%',
            customData: customData,
            reloadEvent: 'AppReload'
        });
        $target.append(boardIframe.render());

        // Render board picker
        if (boards.length === 0) {
            CB.connect('createBoard', function (board) {
                new CB.Dialog({
                    id: "board-collection-picker",
                    width: 800,
                    height: 550,
                    path: '/boards/picker/collection/' + spaceKey,
                    open: true,
                    remove: true
                });
            });
        }
    });
});