/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.metadata;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.plugins.index.api.Extractor2;
import com.atlassian.confluence.plugins.index.api.FieldDescriptor;
import com.atlassian.renderer.util.RendererUtil;
import com.comalatech.confluence.adhoclists.content.ComalaPropertiesSetManager;
import com.comalatech.confluence.adhoclists.metadata.CustomwareMetaDataAccessor;
import com.comalatech.confluence.adhoclists.metadata.MetadataManagerAccessor;
import com.comalatech.confluence.adhoclists.metadata.MetadataMetadataAccessor;
import com.comalatech.confluence.adhoclists.model.GlobalConfig;
import com.comalatech.confluence.adhoclists.module.GlobalConfigManager;
import com.google.common.collect.Sets;
import com.servicerocket.confluence.randombits.metadata.MetadataStorage;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class MetadataExtractor
implements Extractor2 {
    private final ComalaPropertiesSetManager contentPropertyManager;
    private final GlobalConfigManager globalConfigManager;
    private final MetadataManagerAccessor metadataManagerAccessor;
    private GlobalConfig globalConfig;

    public MetadataExtractor(ComalaPropertiesSetManager contentPropertyManager, GlobalConfigManager globalConfigManager, MetadataManagerAccessor metadataManagerAccessor) {
        this.contentPropertyManager = contentPropertyManager;
        this.globalConfigManager = globalConfigManager;
        this.metadataManagerAccessor = metadataManagerAccessor;
    }

    public StringBuilder extractText(Object o) {
        StringBuilder sB = new StringBuilder();
        if (o instanceof Searchable && o instanceof AbstractPage) {
            AbstractPage ceo = (AbstractPage)o;
            if (this.getGlobalConfig().getMetadataAccessorType() == GlobalConfig.MetadataAccessorType.Default) {
                sB.append(this.indexMetadataMetadataText(ceo));
            } else if (this.getGlobalConfig().getMetadataAccessorType() == GlobalConfig.MetadataAccessorType.Scaffold) {
                sB.append(this.indexScaffoldingMetadataText(ceo));
            }
        }
        return sB;
    }

    public Collection<FieldDescriptor> extractFields(Object o) {
        HashSet fields = Sets.newHashSet();
        if (o instanceof Searchable && o instanceof AbstractPage) {
            AbstractPage ceo = (AbstractPage)o;
            if (this.getGlobalConfig().getMetadataAccessorType() == GlobalConfig.MetadataAccessorType.Default) {
                fields.addAll(this.indexMetadataMetadataFields(ceo));
            } else if (this.getGlobalConfig().getMetadataAccessorType() == GlobalConfig.MetadataAccessorType.Scaffold) {
                fields.addAll(this.indexScaffoldingMetadataFields(ceo));
            }
        }
        return fields;
    }

    private StringBuffer indexScaffoldingMetadataText(AbstractPage ceo) {
        CustomwareMetaDataAccessor accessor = new CustomwareMetaDataAccessor(this.metadataManagerAccessor);
        MetadataStorage data = accessor.getStorage(ceo);
        Map baseMap = data.getBaseMap();
        if (baseMap == null || baseMap.size() == 0) {
            return new StringBuffer(0);
        }
        StringBuffer searchableText = new StringBuffer();
        for (String key : baseMap.keySet()) {
            Object value = baseMap.get(key);
            if (value == null || !(value instanceof String)) continue;
            String strippedValue = RendererUtil.stripBasicMarkup((String)((String)value));
            searchableText.append(strippedValue).append(" ");
        }
        return searchableText;
    }

    private Collection<FieldDescriptor> indexScaffoldingMetadataFields(AbstractPage ceo) {
        CustomwareMetaDataAccessor accessor = new CustomwareMetaDataAccessor(this.metadataManagerAccessor);
        MetadataStorage data = accessor.getStorage(ceo);
        if (data != null) {
            Map baseMap = data.getBaseMap();
            if (baseMap == null || baseMap.size() == 0) {
                return Collections.EMPTY_LIST;
            }
            HashSet fields = Sets.newHashSet();
            for (String key : baseMap.keySet()) {
                Object value = baseMap.get(key);
                if (value == null || !(value instanceof String)) continue;
                String strippedValue = RendererUtil.stripBasicMarkup((String)((String)value));
                fields.add(new FieldDescriptor(key, strippedValue, FieldDescriptor.Store.YES, FieldDescriptor.Index.ANALYZED));
            }
            return fields;
        }
        return Collections.EMPTY_LIST;
    }

    private StringBuffer indexMetadataMetadataText(AbstractPage ceo) {
        String[] keys;
        String keysAsString = this.contentPropertyManager.getTextProperty((ContentEntityObject)ceo, "metadatakeys");
        if (!StringUtils.isNotBlank((CharSequence)keysAsString)) {
            return new StringBuffer(0);
        }
        StringBuffer searchableText = new StringBuffer();
        MetadataMetadataAccessor accessor = MetadataMetadataAccessor.getInstance();
        for (String key : keys = keysAsString.split("\\|")) {
            String value = accessor.getValue(ceo, key);
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            String strippedValue = RendererUtil.stripBasicMarkup((String)value);
            searchableText.append(strippedValue).append(" ");
        }
        return searchableText;
    }

    private Collection<FieldDescriptor> indexMetadataMetadataFields(AbstractPage ceo) {
        String[] keys;
        String keysAsString = this.contentPropertyManager.getTextProperty((ContentEntityObject)ceo, "metadatakeys");
        if (!StringUtils.isNotBlank((CharSequence)keysAsString)) {
            return Collections.EMPTY_LIST;
        }
        HashSet fields = Sets.newHashSet();
        MetadataMetadataAccessor accessor = MetadataMetadataAccessor.getInstance();
        for (String key : keys = keysAsString.split("\\|")) {
            String value = accessor.getValue(ceo, key);
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            String strippedValue = RendererUtil.stripBasicMarkup((String)value);
            fields.add(new FieldDescriptor(key, strippedValue, FieldDescriptor.Store.YES, FieldDescriptor.Index.ANALYZED));
        }
        return fields;
    }

    public GlobalConfig getGlobalConfig() {
        if (this.globalConfig == null) {
            this.globalConfig = this.globalConfigManager.loadGlobalConfig();
        }
        return this.globalConfig;
    }
}

