/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.lists.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContextOutputType;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.user.User;
import com.comalatech.confluence.adhoclists.AdhocListsException;
import com.comalatech.confluence.adhoclists.boards.events.AdhocListViewEvent;
import com.comalatech.confluence.adhoclists.cards.CardManager;
import com.comalatech.confluence.adhoclists.cards.model.Cards;
import com.comalatech.confluence.adhoclists.condition.ConditionalMacro;
import com.comalatech.confluence.adhoclists.condition.RestCondition;
import com.comalatech.confluence.adhoclists.license.AdhocLicenseManager;
import com.comalatech.confluence.adhoclists.lists.ChecklistCreator;
import com.comalatech.confluence.adhoclists.lists.ChecklistRenderer;
import com.comalatech.confluence.adhoclists.lists.macro.MacroParameters;
import com.comalatech.confluence.adhoclists.lists.model.Checklist;
import com.comalatech.confluence.adhoclists.lists.model.ChecklistViewContext;
import com.comalatech.confluence.adhoclists.model.Filter;
import com.comalatech.confluence.adhoclists.module.GlobalConfigManager;
import com.comalatech.confluence.adhoclists.storage.AdhocListManager;
import com.comalatech.confluence.adhoclists.utils.AdhocListsUtils;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class AdhocListMacro
extends ConditionalMacro {
    private static final String PARAM_0 = "0";
    static final String PARAM_NAME = "name";
    private static final String PARAM_PARENT = "parent";
    private static final String[] PARAM_SPACEKEY = new String[]{"spacekey", "space"};
    private static final String PARAM_LABELS = "labels";
    private static final String PARAM_DEPTH = "depth";
    private static final String PARAM_ALLSPACES = "allSpaces";
    protected final ChecklistRenderer checklistRenderer;
    protected final AdhocListManager adhocListManager;
    protected final ChecklistCreator checklistCreator;
    protected final GlobalConfigManager globalConfigManager;
    protected final PermissionManager permissionManager;
    protected final CardManager cardManager;
    private final EventPublisher eventPublisher;

    public AdhocListMacro(RestCondition restCondition, SpaceManager spaceManager, ChecklistRenderer checklistRenderer, AdhocListManager adhocListManager, ChecklistCreator checklistCreator, GlobalConfigManager globalConfigManager, AdhocLicenseManager licenseManager, PermissionManager permissionManager, CardManager cardManager, EventPublisher eventPublisher) {
        super(restCondition, spaceManager, licenseManager);
        this.checklistRenderer = checklistRenderer;
        this.adhocListManager = adhocListManager;
        this.checklistCreator = checklistCreator;
        this.globalConfigManager = globalConfigManager;
        this.permissionManager = permissionManager;
        this.cardManager = cardManager;
        this.eventPublisher = eventPublisher;
    }

    public boolean hasBody() {
        return true;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        AbstractPage page;
        Checklist checklist;
        String spaceKey = ((PageContext)renderContext).getSpaceKey();
        this.checkDisplayPermission(this, spaceKey, ConditionalMacro.MacroCondition.SHOWLIST);
        Parameters macroParams = new Parameters(parameters, body, renderContext);
        if (StringUtils.isNotBlank((CharSequence)macroParams.body)) {
            checklist = (Checklist)this.adhocListManager.parseJson(body);
            if (checklist == null) {
                throw new MacroException("Error parsing checklist " + macroParams.name);
            }
        } else if (macroParams.popularLabels) {
            checklist = this.checklistCreator.createPopularLabelsChecklist(spaceKey);
        } else {
            checklist = (Checklist)this.adhocListManager.get(spaceKey, macroParams.name);
            if (checklist == null) {
                checklist = (Checklist)this.adhocListManager.get(macroParams.name);
            }
            if (checklist == null && ConfluenceActionSupport.getTextStatic((String)"title.labels.popular").equals(macroParams.name)) {
                checklist = this.checklistCreator.createPopularLabelsChecklist(spaceKey);
            }
        }
        if (checklist == null) {
            throw new MacroException(String.format("Checklist with name %s doesn't exist", macroParams.name));
        }
        try {
            page = macroParams.getAbstractPage();
        }
        catch (Exception e) {
            page = null;
        }
        ChecklistViewContext viewContext = this.makeChecklistViewContext(checklist, spaceKey, page, macroParams);
        Filter filter = this.makeFilter(macroParams);
        Cards cards = this.cardManager.createCards(checklist.getRows());
        if (cards.isDirty() && !this.adhocListManager.isTableRendered((ContentEntityObject)page, checklist.getId())) {
            this.cardManager.saveCards((ContentEntityObject)page, checklist.getId(), cards);
            this.adhocListManager.setTableRendered((ContentEntityObject)page, checklist.getId());
        }
        try {
            if (ConversionContextOutputType.PREVIEW.name().equals(renderContext.getOutputType())) {
                viewContext.setPreview(true);
            }
            this.eventPublisher.publish((Object)new AdhocListViewEvent());
            return this.checklistRenderer.renderChecklist(viewContext, checklist, filter);
        }
        catch (AdhocListsException e) {
            throw new MacroException(e.getMessage(), (Throwable)e);
        }
    }

    private Filter makeFilter(Parameters macroParams) {
        Filter filter = new Filter();
        if (StringUtils.isNotBlank((CharSequence)macroParams.parent)) {
            filter.setParent(macroParams.parent);
        }
        if (StringUtils.isNotBlank((CharSequence)macroParams.spaceKey)) {
            filter.setSpaceKey(macroParams.spaceKey);
        }
        if (StringUtils.isNotBlank((CharSequence)macroParams.labels)) {
            filter.setLabels(Lists.newArrayList((Object[])macroParams.labels.split(",")));
        }
        filter.setDepth(macroParams.depth);
        filter.setAllSpaces(macroParams.allSpaces);
        return filter;
    }

    private ChecklistViewContext makeChecklistViewContext(Checklist checklist, String spaceKey, AbstractPage page, Parameters macroParams) {
        int start = 0;
        int max = AdhocListsUtils.retrieveMaximumRowsForList(this.globalConfigManager, checklist.getMaxRows(), this.getLicenseManager().isLicensed());
        ChecklistViewContext viewContext = new ChecklistViewContext(spaceKey, start, max);
        viewContext.setPage(page);
        viewContext.setReadOnly(AuthenticatedUserThreadLocal.get() == null || !this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.EDIT, (Object)page) || !this.getLicenseManager().isLicensed());
        List<String> supportedExportFormats = Arrays.asList("pdf", "word");
        if (supportedExportFormats.contains(macroParams.outputType)) {
            viewContext.setPageExport(true);
        }
        return viewContext;
    }

    protected static class Parameters
    extends MacroParameters {
        String name;
        String parent;
        int depth;
        String spaceKey;
        boolean popularLabels;
        String body;
        String labels;
        String outputType;
        boolean allSpaces;

        Parameters(Map parameters, String body, RenderContext renderContext) throws MacroException {
            super(parameters, renderContext);
            String stringParam = this.get(AdhocListMacro.PARAM_NAME);
            if (!StringUtils.isNotBlank((CharSequence)stringParam)) {
                stringParam = this.get(AdhocListMacro.PARAM_0);
            }
            this.name = stringParam;
            this.parent = this.get(AdhocListMacro.PARAM_PARENT);
            this.labels = this.get(AdhocListMacro.PARAM_LABELS);
            if (StringUtils.isNotBlank((CharSequence)this.labels)) {
                this.labels = this.labels.replaceAll(" ", "");
            }
            this.depth = this.getInt(AdhocListMacro.PARAM_DEPTH, 0);
            this.spaceKey = this.get(PARAM_SPACEKEY);
            this.outputType = renderContext.getOutputType();
            this.popularLabels = this.getFlagWithDefault("popularlabels", false);
            this.allSpaces = this.getFlagWithDefault(AdhocListMacro.PARAM_ALLSPACES, false);
            if (StringUtils.isNotBlank((CharSequence)body) && StringUtils.isNotBlank((CharSequence)(body = AdhocListsUtils.clean(body)))) {
                this.body = body.trim();
            }
        }
    }
}

