/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.lists;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.user.User;
import com.comalatech.confluence.adhoclists.AdhocListsException;
import com.comalatech.confluence.adhoclists.cards.CardManager;
import com.comalatech.confluence.adhoclists.cards.model.Cards;
import com.comalatech.confluence.adhoclists.cards.model.ResolvedCard;
import com.comalatech.confluence.adhoclists.filter.FilterManager;
import com.comalatech.confluence.adhoclists.license.AdhocLicenseManager;
import com.comalatech.confluence.adhoclists.lists.ChecklistRenderer;
import com.comalatech.confluence.adhoclists.lists.ChecklistResolver;
import com.comalatech.confluence.adhoclists.lists.accessor.AccessorFactory;
import com.comalatech.confluence.adhoclists.lists.accessor.ValueAccessor;
import com.comalatech.confluence.adhoclists.lists.model.Cell;
import com.comalatech.confluence.adhoclists.lists.model.Checklist;
import com.comalatech.confluence.adhoclists.lists.model.ChecklistViewContext;
import com.comalatech.confluence.adhoclists.lists.model.Column;
import com.comalatech.confluence.adhoclists.lists.model.ListRows;
import com.comalatech.confluence.adhoclists.lists.types.LabelColumn;
import com.comalatech.confluence.adhoclists.model.Filter;
import com.comalatech.confluence.adhoclists.model.ResolvedFilter;
import com.comalatech.confluence.adhoclists.model.StyledColor;
import com.comalatech.confluence.adhoclists.storage.serializer.ChecklistJsonSerializer;
import com.comalatech.confluence.adhoclists.utils.VelocityPageHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DefaultChecklistRenderer
implements ChecklistRenderer {
    private ChecklistResolver checklistResolver;
    private ChecklistJsonSerializer checklistJsonSerializer;
    private FilterManager filterManager;
    private VelocityPageHelper velocityPageHelper;
    private WikiStyleRenderer wikiStyleRenderer;
    private PermissionManager permissionManager;
    private SpaceManager spaceManager;
    private AdhocLicenseManager licenseManager;
    private CardManager cardManager;

    public DefaultChecklistRenderer(ChecklistResolver checklistResolver, ChecklistJsonSerializer checklistJsonSerializer, FilterManager filterManager, VelocityPageHelper velocityPageHelper, WikiStyleRenderer wikiStyleRenderer, PermissionManager permissionManager, SpaceManager spaceManager, AdhocLicenseManager licenseManager, CardManager cardManager) {
        this.checklistResolver = checklistResolver;
        this.checklistJsonSerializer = checklistJsonSerializer;
        this.filterManager = filterManager;
        this.velocityPageHelper = velocityPageHelper;
        this.wikiStyleRenderer = wikiStyleRenderer;
        this.permissionManager = permissionManager;
        this.spaceManager = spaceManager;
        this.licenseManager = licenseManager;
        this.cardManager = cardManager;
    }

    @Override
    public String renderChecklist(ChecklistViewContext viewContext, Checklist checklist) throws AdhocListsException {
        return this.renderChecklist(viewContext, checklist, "templates/adhoclists/vm/checklists/checklist.vm", null, false);
    }

    @Override
    public String renderChecklist(ChecklistViewContext viewContext, Checklist checklist, Filter filter) throws AdhocListsException {
        return this.renderChecklist(viewContext, checklist, "templates/adhoclists/vm/checklists/checklist.vm", filter, false);
    }

    @Override
    public String renderChecklist(ChecklistViewContext viewContext, Checklist checklist, AdhocListsException exception) throws AdhocListsException {
        return this.renderChecklistError(viewContext, checklist, "templates/adhoclists/vm/checklists/checklist-error.vm", exception);
    }

    @Override
    public String renderChecklistDesigner(ChecklistViewContext viewContext, Checklist checklist) throws AdhocListsException {
        viewContext.setPreview(true);
        return this.renderChecklist(viewContext, checklist, "templates/adhoclists/vm/checklists/checklistdesigner.vm", null, true);
    }

    private String renderChecklist(ChecklistViewContext viewContext, Checklist checklist, String template, Filter filter, boolean designerView) throws AdhocListsException {
        Cards cards;
        Filter searchFilter = filter;
        if (searchFilter == null) {
            searchFilter = new Filter();
        }
        viewContext.setSortType(checklist.getSortType());
        ResolvedFilter resolvedFilter = this.filterManager.resolve(searchFilter, viewContext);
        List<SpaceContentEntityObject> pages = this.checklistResolver.getRows(viewContext, resolvedFilter);
        viewContext.setUserCanAddPages(this.canCreatePages(viewContext, resolvedFilter, checklist));
        Map contextMap = MacroUtils.defaultVelocityContext();
        contextMap.put("pages", pages);
        if (viewContext.getPage() != null && (cards = this.cardManager.getCards((ContentEntityObject)viewContext.getPage(), checklist.getId())).size() > 0) {
            viewContext.setChecklist(true);
            contextMap.put("cards", cards);
        }
        contextMap.put("checklist", checklist);
        contextMap.put("rowClasses", this.makeRowColorClasses(checklist));
        contextMap.put("rowCreator", this.makeRowCreator(viewContext.isReadOnly(), checklist.getColumns()));
        String json = this.checklistJsonSerializer.serialize(checklist);
        contextMap.put("jsonChecklist", json);
        contextMap.put("viewContext", viewContext);
        resolvedFilter.setDepth(searchFilter.getDepth());
        contextMap.put("filter", resolvedFilter);
        contextMap.put("helper", this.velocityPageHelper);
        contextMap.put("licenseManager", this.licenseManager);
        contextMap.put("descriptionHtml", this.renderDescription(checklist));
        try {
            return VelocityUtils.getRenderedTemplate((String)template, (Map)contextMap);
        }
        catch (Exception e) {
            throw new AdhocListsException(e);
        }
    }

    private boolean canCreatePages(ChecklistViewContext viewContext, ResolvedFilter resolvedFilter, Checklist checklist) {
        String spaceKey;
        if (viewContext.isReadOnly()) {
            return false;
        }
        if (!checklist.canAddRows()) {
            return false;
        }
        String string = spaceKey = StringUtils.isNotBlank((CharSequence)resolvedFilter.getSpaceKey()) ? resolvedFilter.getSpaceKey() : viewContext.getSpaceKey();
        if (!viewContext.getSpaceKey().equals(spaceKey)) {
            return false;
        }
        Space space = this.spaceManager.getSpace(spaceKey);
        return this.permissionManager.hasCreatePermission((User)AuthenticatedUserThreadLocal.get(), (Object)space, Page.class);
    }

    private String renderDescription(Checklist checklist) {
        String description = checklist.getDescription();
        String descriptionHtml = StringUtils.isNotBlank((CharSequence)description) ? this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)new PageContext(), description) : "";
        return descriptionHtml;
    }

    private String renderChecklistError(ChecklistViewContext viewContext, Checklist checklist, String template, AdhocListsException exception) throws AdhocListsException {
        Map contextMap = MacroUtils.defaultVelocityContext();
        String json = this.checklistJsonSerializer.serialize(checklist);
        contextMap.put("jsonChecklist", json);
        contextMap.put("checklist", checklist);
        contextMap.put("exception", exception);
        contextMap.put("viewContext", viewContext);
        try {
            return VelocityUtils.getRenderedTemplate((String)template, (Map)contextMap);
        }
        catch (Exception e) {
            throw new AdhocListsException(e);
        }
    }

    @Override
    public ListRows renderPages(ChecklistViewContext viewContext, Checklist checklist, Filter filter, Page parent) throws AdhocListsException {
        viewContext.setSortType(checklist.getSortType());
        ResolvedFilter resolvedFilter = this.filterManager.resolve(filter, viewContext);
        resolvedFilter.setParentPage(parent);
        List<SpaceContentEntityObject> pages = this.checklistResolver.getRows(viewContext, resolvedFilter);
        String rowsHtml = this.renderPages(viewContext, checklist, pages);
        return new ListRows(rowsHtml, viewContext.getStart(), viewContext.isHasMore());
    }

    @Override
    public String renderPage(ChecklistViewContext viewContext, Checklist checklist, AbstractPage page) throws AdhocListsException {
        ArrayList<SpaceContentEntityObject> pages = new ArrayList<SpaceContentEntityObject>(1);
        pages.add((SpaceContentEntityObject)page);
        return this.renderPages(viewContext, checklist, pages);
    }

    private String renderPages(ChecklistViewContext viewContext, Checklist checklist, List<SpaceContentEntityObject> pages) throws AdhocListsException {
        Map contextMap = MacroUtils.defaultVelocityContext();
        contextMap.put("pages", pages);
        contextMap.put("checklist", checklist);
        contextMap.put("rowCreator", this.makeRowCreator(viewContext.isReadOnly(), checklist.getColumns()));
        contextMap.put("viewContext", viewContext);
        contextMap.put("helper", this.velocityPageHelper);
        try {
            return VelocityUtils.getRenderedTemplate((String)"templates/adhoclists/vm/checklists/rows.vm", (Map)contextMap);
        }
        catch (Exception e) {
            throw new AdhocListsException(e);
        }
    }

    private List<RowColorClass> makeRowColorClasses(Checklist checklist) {
        ArrayList<RowColorClass> classes = new ArrayList<RowColorClass>();
        for (Column column : checklist.getColumns()) {
            LabelColumn labelColumn;
            if (!(column instanceof LabelColumn) || !StringUtils.isNotBlank((CharSequence)(labelColumn = (LabelColumn)column).getColor())) continue;
            try {
                classes.add(new RowColorClass(labelColumn.getValueType().getLabelCssClass(), labelColumn.getColor()));
            }
            catch (Exception exception) {}
        }
        return classes;
    }

    private RowCreator makeRowCreator(boolean readOnly, List<Column> columns) {
        ArrayList<ValueAccessor> accessors = new ArrayList<ValueAccessor>(columns.size());
        for (Column column : columns) {
            accessors.add(AccessorFactory.makeValueAccessor(column));
        }
        return new RowCreator(readOnly, accessors);
    }

    public class RowCreator {
        List<ValueAccessor> accessors;
        private boolean readOnly;

        public RowCreator(boolean readOnly, List<ValueAccessor> accessors) {
            this.accessors = accessors;
            this.readOnly = readOnly;
        }

        public List<Cell> makeEmptyCells() {
            ArrayList<Cell> cells = new ArrayList<Cell>(this.accessors.size());
            for (ValueAccessor accessor : this.accessors) {
                Cell cell = accessor.getEmptyCell();
                cell.setEmpty(true);
                cells.add(cell);
            }
            return cells;
        }

        public Row makeRow(SpaceContentEntityObject ceo) {
            return new Row(ceo, null);
        }

        public Row makeRow(SpaceContentEntityObject ceo, ResolvedCard card) {
            return new Row(ceo, card);
        }

        public List<ValueAccessor> getAccessors() {
            return this.accessors;
        }

        public class Row {
            private List<Cell> cells;
            private StringBuffer labelClasses;

            public Row(SpaceContentEntityObject ceo, ResolvedCard card) {
                this.cells = new ArrayList<Cell>(RowCreator.this.accessors.size());
                this.labelClasses = new StringBuffer();
                boolean canEdit = DefaultChecklistRenderer.this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.EDIT, (Object)ceo);
                for (ValueAccessor accessor : RowCreator.this.accessors) {
                    Cell cell = accessor.getCell(ceo, card);
                    cell.setReadOnly(RowCreator.this.readOnly || accessor.getColumn().isReadOnly() || !canEdit);
                    String cssClass = cell.getCssClass();
                    if (cssClass != null) {
                        this.labelClasses.append(cssClass).append(" ");
                    }
                    this.cells.add(cell);
                }
            }

            public List<Cell> getCells() {
                return this.cells;
            }

            public StringBuffer getLabelClasses() {
                return this.labelClasses;
            }
        }
    }

    public static class RowColorClass {
        private String className;
        private StyledColor color;

        public RowColorClass(String className, String color) {
            this.className = className;
            this.color = new StyledColor(color);
        }

        public String getClassName() {
            return this.className;
        }

        public StyledColor getColor() {
            return this.color;
        }
    }
}

