/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.storage.action;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.atlassian.confluence.spaces.actions.SpaceAware;
import com.atlassian.user.User;
import com.atlassian.xwork.ParameterSafe;
import com.comalatech.confluence.adhoclists.license.AdhocLicenseManager;
import com.comalatech.confluence.adhoclists.license.PluginLicenseAware;

public abstract class AbstractSpaceTableAction
extends AbstractSpaceAction
implements SpaceAware,
PluginLicenseAware {
    protected AdhocLicenseManager licenseManager;
    protected Type type;
    protected NamedTable currentTable;
    protected String name;

    public boolean isCanAdmin() {
        return this.licenseManager.isLicensed() && (this.permissionManager.isConfluenceAdministrator((User)this.getAuthenticatedUser()) || this.permissionManager.hasPermission((User)this.getAuthenticatedUser(), Permission.ADMINISTER, (Object)this.getSpace()));
    }

    public boolean isSpaceRequired() {
        return true;
    }

    public boolean isViewPermissionRequired() {
        return true;
    }

    @ParameterSafe
    public void setType(String name) {
        this.type = Type.parse(name);
    }

    public String getType() {
        return this.type.toString();
    }

    public NamedTable getCurrentTable() {
        return this.currentTable;
    }

    @ParameterSafe
    public void setName(String name) {
        this.name = name;
    }

    public boolean isCanAdd() {
        return this.type != Type.NEW;
    }

    @Override
    public AdhocLicenseManager getLicenseManager() {
        return this.licenseManager;
    }

    public void setLicenseManager(AdhocLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public static class NamedTable {
        String name;
        Type type;
        boolean current;

        public NamedTable(String name, Type type, boolean current) {
            this.name = name;
            this.type = type;
            this.current = current;
        }

        public NamedTable(String spaceKey, String name, Type type, boolean current) {
            this.name = name;
            this.type = type;
            this.current = current;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type.name;
        }

        public boolean isCurrent() {
            return this.current;
        }

        public boolean isEditable() {
            return this.type == Type.CUSTOM;
        }
    }

    public static enum Type {
        POPULAR_LABELS("popularlabels"),
        PAGES("pages"),
        CUSTOM("custom"),
        NEW("new"),
        EDIT("edit");

        String name;

        private Type(String name) {
            this.name = name;
        }

        static Type parse(String name) {
            for (Type type : Type.values()) {
                if (!type.name.equalsIgnoreCase(name)) continue;
                return type;
            }
            return POPULAR_LABELS;
        }
    }
}

