/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.storage;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.adhoclists.model.Table;
import java.util.List;

public interface TableManager<T extends Table> {
    public List<String> getNames(String var1);

    public List<String> getBundledNames();

    public List<TableDescriptor<T>> getBundledDescriptors(boolean var1);

    public List<TableDescriptor<T>> getAllDescriptors(String var1);

    public boolean hasTables(String var1);

    public List<TableDescriptor<T>> getSpaceTables(String var1);

    public T get(String var1);

    public void save(String var1, T var2);

    public T parseJson(String var1);

    public T deserialize(String var1);

    public String serialize(T var1);

    public T deserializeJson(String var1);

    public String serializeJson(T var1);

    public T get(String var1, String var2);

    public String getNewTableName(ConfluenceEntityObject var1);

    public void delete(String var1, String var2);

    public String getBandanaKey();

    public String makeCopyName(String var1, String var2);

    @Deprecated
    public boolean isTableRendered(ContentEntityObject var1, String var2);

    @Deprecated
    public void setTableRendered(ContentEntityObject var1, String var2);

    public T getBundled(long var1);

    public T makeEmpty();

    public T getFromPage(long var1);

    public T getFromPage(AbstractPage var1);

    public static class TableDescriptor<T extends Table> {
        long id;
        String spaceKey;
        String name;
        String wizard;
        String hostPageTitle;
        Type type;
        T table;

        public TableDescriptor(String spaceKey, T table) {
            this.type = Type.SPACE;
            this.name = table.getName();
            this.id = this.name.hashCode();
            this.spaceKey = spaceKey;
            this.table = table;
        }

        public TableDescriptor(T table) {
            this.type = Type.BUNDLED;
            this.name = table.getName();
            this.id = this.name.hashCode();
            this.table = table;
        }

        public TableDescriptor(long id, T table) {
            this.id = id;
            this.name = table.getName();
            this.table = table;
            this.type = Type.PAGE;
        }

        public TableDescriptor(AbstractPage page, T table) {
            this.id = page.getId();
            this.name = table.getName();
            this.table = table;
            this.type = Type.PAGE;
            this.hostPageTitle = page.getTitle();
        }

        public TableDescriptor(long id, String name) {
            this.id = id;
            this.name = name;
            this.type = Type.EMPTY;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public long getId() {
            return this.id;
        }

        public String getSpaceKey() {
            return this.spaceKey;
        }

        public void setSpaceKey(String spaceKey) {
            this.spaceKey = spaceKey;
        }

        public Type getType() {
            return this.type;
        }

        public T getTable() {
            return this.table;
        }

        public String getWizard() {
            return this.wizard;
        }

        public void setWizard(String wizard) {
            this.wizard = wizard;
        }

        public String getHostPageTitle() {
            return this.hostPageTitle;
        }

        public static enum Type {
            BUNDLED,
            SPACE,
            PAGE,
            EMPTY;

        }
    }
}

