/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.rest;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.message.I18nResolver;
import com.comalatech.confluence.adhoclists.AdhocListsException;
import com.comalatech.confluence.adhoclists.boards.BoardHandler;
import com.comalatech.confluence.adhoclists.boards.BoardRenderer;
import com.comalatech.confluence.adhoclists.boards.BoardValidator;
import com.comalatech.confluence.adhoclists.boards.events.BoardDesignerOpenedEvent;
import com.comalatech.confluence.adhoclists.boards.events.BoardPageCreatedEvent;
import com.comalatech.confluence.adhoclists.boards.events.CardCreatedEvent;
import com.comalatech.confluence.adhoclists.boards.view.LabelBoardResolver;
import com.comalatech.confluence.adhoclists.boards.view.model.RenderedCard;
import com.comalatech.confluence.adhoclists.boards.view.model.ResolvedContainer;
import com.comalatech.confluence.adhoclists.cards.CardManager;
import com.comalatech.confluence.adhoclists.cards.model.Card;
import com.comalatech.confluence.adhoclists.cards.model.Cards;
import com.comalatech.confluence.adhoclists.condition.RestCondition;
import com.comalatech.confluence.adhoclists.exceptions.InvalidParentException;
import com.comalatech.confluence.adhoclists.filter.FilterManager;
import com.comalatech.confluence.adhoclists.model.Filter;
import com.comalatech.confluence.adhoclists.model.ResolvedFilter;
import com.comalatech.confluence.adhoclists.model.Styles;
import com.comalatech.confluence.adhoclists.module.GlobalConfigManager;
import com.comalatech.confluence.adhoclists.rest.AbstractRestResources;
import com.comalatech.confluence.adhoclists.rest.AdhocListsRestException;
import com.comalatech.confluence.adhoclists.rest.PermissionRequired;
import com.comalatech.confluence.adhoclists.rest.model.MorePages;
import com.comalatech.confluence.adhoclists.storage.BoardManager;
import com.comalatech.confluence.adhoclists.storage.serializer.BoardJsonSerializer;
import com.comalatech.confluence.adhoclists.storage.serializer.BoardSerializer;
import com.comalatech.confluence.adhoclists.storage.serializer.BoardXmlSerializer;
import com.comalatech.confluence.adhoclists.templates.AdhocTemplateManager;
import com.comalatech.confluence.boards.model.Board;
import com.comalatech.confluence.boards.model.BoardViewContext;
import com.comalatech.confluence.boards.model.Container;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Qualifier;

@Path(value="/boards")
public class BoardResources
extends AbstractRestResources<Board> {
    private final BoardHandler boardHandler;
    private final BoardRenderer boardRenderer;
    private final BoardManager boardManager;
    private final BoardXmlSerializer boardXmlSerializer;
    private final BoardJsonSerializer boardJsonSerializer;
    private final LabelBoardResolver labelBoardResolver;
    private final CardManager cardManager;
    private final GlobalConfigManager globalConfigManager;
    private final EventPublisher eventPublisher;

    public BoardResources(PageManager pageManager, SpaceManager spaceManager, PermissionManager permissionManager, LabelManager labelManager, FilterManager filterManager, @Qualifier(value="contentEntityManager") ContentEntityManager contentEntityManager, AdhocTemplateManager adhocTemplateManager, PageTemplateManager pageTemplateManager, I18nResolver i18nResolver, RestCondition restCondition, BoardValidator boardValidator, BoardHandler boardHandler, BoardRenderer boardRenderer, BoardManager boardManager, BoardXmlSerializer boardXmlSerializer, BoardJsonSerializer boardJsonSerializer, LabelBoardResolver labelBoardResolver, CardManager cardManager, GlobalConfigManager globalConfigManager, EventPublisher eventPublisher) {
        super(pageManager, spaceManager, permissionManager, labelManager, filterManager, contentEntityManager, adhocTemplateManager, pageTemplateManager, i18nResolver, restCondition, boardValidator);
        this.boardHandler = boardHandler;
        this.boardRenderer = boardRenderer;
        this.boardManager = boardManager;
        this.boardXmlSerializer = boardXmlSerializer;
        this.boardJsonSerializer = boardJsonSerializer;
        this.labelBoardResolver = labelBoardResolver;
        this.cardManager = cardManager;
        this.globalConfigManager = globalConfigManager;
        this.eventPublisher = eventPublisher;
    }

    @POST
    @PermissionRequired(permissionTypes={PermissionRequired.Type.VIEW, PermissionRequired.Type.EDIT, PermissionRequired.Type.SHOWBOARD})
    @Path(value="/{pageId}/move")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response move(@PathParam(value="pageId") long pageId, final @QueryParam(value="containingPageId") long containingPageId, final @QueryParam(value="from") String from, final @QueryParam(value="fromFilter") String fromFilter, final @QueryParam(value="fromTitle") String fromTitle, final @QueryParam(value="fromColour") String fromColour, final @QueryParam(value="to") String to, final @QueryParam(value="toFilter") String toFilter, final @QueryParam(value="toTitle") String toTitle, final @QueryParam(value="toColour") String toColour, final @QueryParam(value="nextId") String nextId, final @QueryParam(value="notify") boolean isNotify, final @QueryParam(value="nextCard") String nextCard, String body) {
        return new AbstractRestResources.PageRestCommand(){

            @Override
            protected Response doInCommand(AbstractPage page) throws AdhocListsException {
                AbstractPage containingPage = this.getNullablePage(containingPageId);
                BoardResources.this.boardHandler.move((ContentEntityObject)containingPage, (Page)page, from, fromFilter, fromTitle, fromColour, to, toFilter, toTitle, toColour, BoardResources.this.makeCardReference(nextId, nextCard), isNotify);
                return Response.ok().build();
            }
        }.execute(pageId);
    }

    @POST
    @PermissionRequired(permissionTypes={PermissionRequired.Type.VIEW, PermissionRequired.Type.EDIT, PermissionRequired.Type.SHOWBOARD})
    @Path(value="/{pageId}/card/move")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response moveCard(@PathParam(value="pageId") long pageId, final @QueryParam(value="from") String from, final @QueryParam(value="fromTitle") String fromTitle, final @QueryParam(value="fromColour") String fromColour, final @QueryParam(value="to") String to, final @QueryParam(value="toTitle") String toTitle, final @QueryParam(value="toColour") String toColour, final @QueryParam(value="notify") boolean isNotify, final @QueryParam(value="nextId") String nextId, final @QueryParam(value="nextCard") String nextCard, final String body) {
        return new AbstractRestResources.PageRestCommand(){

            @Override
            protected Response doInCommand(AbstractPage page) throws AdhocListsException {
                BoardResources.this.boardHandler.move((ContentEntityObject)page, body, from, fromTitle, fromColour, to, toTitle, toColour, BoardResources.this.makeCardReference(nextId, nextCard), isNotify);
                return Response.ok().build();
            }
        }.execute(pageId);
    }

    @POST
    @PermissionRequired(permissionTypes={PermissionRequired.Type.VIEW, PermissionRequired.Type.EDIT, PermissionRequired.Type.SHOWBOARD})
    @Path(value="/{pageId}/remove")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response removePage(final @PathParam(value="pageId") long pageId, final @QueryParam(value="containingPageId") long containingPageId, final @QueryParam(value="key") String key) {
        return new AbstractRestResources.PageRestCommand(){

            @Override
            protected Response doInCommand(AbstractPage page) throws AdhocListsException {
                AbstractPage containingPage = this.getNullablePage(containingPageId);
                if (containingPage != null) {
                    BoardResources.this.checkPermission((ConfluenceEntityObject)containingPage, PermissionRequired.Type.EDIT);
                }
                BoardResources.this.boardHandler.remove((ContentEntityObject)containingPage, key, BoardResources.this.makeCardReference(pageId, null));
                return Response.ok().build();
            }
        }.execute(pageId);
    }

    @POST
    @PermissionRequired(permissionTypes={PermissionRequired.Type.VIEW, PermissionRequired.Type.EDIT, PermissionRequired.Type.SHOWBOARD})
    @Path(value="/{pageId}/card/remove")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response removeCard(@PathParam(value="pageId") long pageId, final String body, final @QueryParam(value="key") String key) {
        return new AbstractRestResources.PageRestCommand(){

            @Override
            protected Response doInCommand(AbstractPage containingPage) throws AdhocListsException {
                BoardResources.this.boardHandler.remove((ContentEntityObject)containingPage, key, BoardResources.this.makeCardReference(null, body));
                return Response.ok().build();
            }
        }.execute(pageId);
    }

    @POST
    @PermissionRequired(permissionTypes={PermissionRequired.Type.VIEW, PermissionRequired.Type.EDIT, PermissionRequired.Type.SHOWBOARD})
    @Path(value="/{pageId}/remove-cards")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response removeCards(@PathParam(value="pageId") long pageId, final Map[] data) {
        return new AbstractRestResources.PageRestCommand(){

            @Override
            protected Response doInCommand(AbstractPage page) throws AdhocListsException {
                BoardResources.this.boardHandler.removeCards((ContentEntityObject)page, data);
                for (Map containerData : data) {
                    if (!containerData.containsKey("container")) continue;
                    String key = (String)containerData.get("container");
                    if (!containerData.containsKey("pages")) continue;
                    List pages = (List)containerData.get("pages");
                    for (String referencedPageId : pages) {
                        AbstractPage referencedPage = this.getNullablePage(Long.parseLong(referencedPageId));
                        if (referencedPage != null) {
                            BoardResources.this.checkPermission((ConfluenceEntityObject)referencedPage, PermissionRequired.Type.EDIT);
                        }
                        BoardResources.this.boardHandler.remove((ContentEntityObject)page, key, BoardResources.this.makeCardReference(referencedPageId, null));
                    }
                }
                return Response.ok().build();
            }
        }.execute(pageId);
    }

    @POST
    @PermissionRequired(permissionTypes={PermissionRequired.Type.VIEW, PermissionRequired.Type.EDIT, PermissionRequired.Type.SHOWBOARD})
    @Path(value="/{pageId}/card/update")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response update(@PathParam(value="pageId") long pageId, final @QueryParam(value="containerId") String containerId, final Map<String, String> data) {
        return new AbstractRestResources.PageRestCommand(){

            @Override
            protected Response doInCommand(AbstractPage containingPage) throws AdhocListsException {
                String body = (String)data.get("body");
                String newBody = (String)data.get("newBody");
                RenderedCard card = BoardResources.this.boardHandler.updateCard((ContentEntityObject)containingPage, containerId, new Card(null, body), newBody);
                return Response.ok((Object)card).build();
            }
        }.execute(pageId);
    }

    @PermissionRequired(permissionTypes={PermissionRequired.Type.VIEW, PermissionRequired.Type.CREATEPAGE})
    @POST
    @Path(value="/{spaceKey}/page/add")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response createPage(@PathParam(value="spaceKey") String currentSpaceKey, final @QueryParam(value="pageSpaceKey") String pageSpaceKey, final @QueryParam(value="type") String type, final @QueryParam(value="containerId") String containerId, final @QueryParam(value="filterKey") String filterKey, final @QueryParam(value="title") String title, final @QueryParam(value="toTitle") String toContainerTitle, final @QueryParam(value="color") String color, final @QueryParam(value="parentId") long parentId, final @QueryParam(value="pageId") long pageId, final @QueryParam(value="notify") boolean isNotify, final String wiki) {
        return new AbstractRestResources.SpaceRestCommand(){

            @Override
            protected Response doInCommand(Space currentSpace) throws AdhocListsException {
                if (!TextUtils.stringSet((String)title.trim()) || !AbstractPage.isValidPageTitle((String)title)) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Invalid Title " + title)).build();
                }
                Page parent = (Page)this.getNullablePage(parentId);
                AbstractPage containingPage = this.getNullablePage(pageId);
                if (containingPage != null) {
                    BoardResources.this.checkPermission((ConfluenceEntityObject)containingPage, PermissionRequired.Type.EDIT);
                }
                try {
                    Page existingPage = this.getNullablePage(currentSpace.getKey(), title);
                    if (existingPage != null) {
                        BoardResources.this.checkPermission((ConfluenceEntityObject)existingPage, PermissionRequired.Type.EDIT);
                    }
                    RenderedCard card = BoardResources.this.boardHandler.addPage(Board.Type.parse(type), currentSpace, pageSpaceKey, title, wiki, containerId, filterKey, toContainerTitle, color, parent, containingPage, isNotify);
                    BoardResources.this.eventPublisher.publish((Object)new BoardPageCreatedEvent());
                    return Response.ok((Object)card).build();
                }
                catch (InvalidParentException e) {
                    throw new AdhocListsRestException(400, e.getMessage());
                }
            }
        }.execute(currentSpaceKey);
    }

    @PermissionRequired(permissionTypes={PermissionRequired.Type.EDIT})
    @POST
    @Path(value="/{pageId}/card/add")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response createCard(@PathParam(value="pageId") long pageId, final @QueryParam(value="containerId") String containerId, final @QueryParam(value="toTitle") String toContainerTitle, final @QueryParam(value="color") String color, final @QueryParam(value="notify") boolean isNotify, final String body) {
        return new AbstractRestResources.PageRestCommand(){

            @Override
            protected Response doInCommand(AbstractPage page) {
                Card card;
                try {
                    card = new Card(null, body);
                }
                catch (IllegalArgumentException e) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Cannot create empty card").build();
                }
                RenderedCard renderedCard = BoardResources.this.boardHandler.addCard(page, containerId, toContainerTitle, color, card, isNotify);
                BoardResources.this.eventPublisher.publish((Object)new CardCreatedEvent());
                return Response.ok((Object)renderedCard).build();
            }
        }.execute(pageId);
    }

    @POST
    @PermissionRequired(permissionTypes={PermissionRequired.Type.VIEW, PermissionRequired.Type.EDIT, PermissionRequired.Type.SHOWBOARD})
    @Path(value="/{spaceKey}/save")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response save(@PathParam(value="spaceKey") String spaceKey, final @QueryParam(value="labels") String labels, final @QueryParam(value="parent") String parent, final Board board) {
        return new AbstractRestResources.SpaceRestCommand(){

            @Override
            protected Response doInCommand(Space space) throws AdhocListsException {
                BoardResources.this.validateBoard(board);
                if (TextUtils.stringSet((String)board.getName())) {
                    BoardResources.this.boardManager.save(space.getKey(), board);
                    Filter filter = new Filter(BoardResources.this.getLabels(labels));
                    filter.setParent(parent);
                    BoardResources.this.filterManager.save(space.getKey(), board, filter);
                }
                return Response.ok().build();
            }
        }.execute(spaceKey);
    }

    @GET
    @PermissionRequired(permissionTypes={PermissionRequired.Type.VIEW, PermissionRequired.Type.SHOWBOARD})
    @Path(value="/{spaceKey}/board")
    @Produces(value={"application/json"})
    public Response getSpaceBoard(final @PathParam(value="spaceKey") String spaceKey, final @QueryParam(value="boardName") String boardName) {
        return new AbstractRestResources.SpaceRestCommand(){

            @Override
            protected Response doInCommand(Space space) {
                Board board = (Board)BoardResources.this.boardManager.get(spaceKey, boardName);
                if (board != null) {
                    return Response.ok((Object)board).build();
                }
                return Response.noContent().build();
            }
        }.execute(spaceKey);
    }

    @GET
    @PermissionRequired(permissionTypes={PermissionRequired.Type.VIEW})
    @Path(value="/{spaceKey}/more")
    @Produces(value={"application/json"})
    public Response more(final @PathParam(value="spaceKey") String spaceKey, final @QueryParam(value="label") String containerLabels, final @QueryParam(value="labels") String filterLabels, final @QueryParam(value="allKeys") String allBoardKeys, final @QueryParam(value="parentId") long parentId, final @QueryParam(value="pageId") long pageId, final @QueryParam(value="start") int start, final @QueryParam(value="maxRows") int maxRows) {
        return new AbstractRestResources.SpaceRestCommand(){

            @Override
            protected Response doInCommand(Space space) throws AdhocListsException {
                BoardResources.this.getLabels(containerLabels);
                Page parent = null;
                if (parentId > 0L) {
                    parent = (Page)this.getPage(parentId);
                }
                ResolvedFilter filter = new ResolvedFilter(BoardResources.this.getLabels(filterLabels), parent);
                HashSet boardKeySet = Sets.newHashSet((Object[])allBoardKeys.split(":"));
                BoardViewContext viewContext = new BoardViewContext(spaceKey, boardKeySet);
                viewContext.setCount(maxRows == 0 ? Integer.MAX_VALUE : maxRows);
                if (pageId > 0L) {
                    Page boardPage = (Page)this.getPage(pageId);
                    viewContext.setPage((AbstractPage)boardPage);
                }
                ResolvedContainer container = BoardResources.this.labelBoardResolver.getExpandedContainer(viewContext, filter, new Container(containerLabels), start);
                String pageHtml = BoardResources.this.renderTemplateHtml("templates/adhoclists/vm/boards/containerpages.vm", "entities", container.getEntities());
                return Response.ok((Object)new MorePages(pageHtml, container.isHasMoreEntities())).build();
            }
        }.execute(spaceKey);
    }

    @POST
    @PermissionRequired(permissionTypes={PermissionRequired.Type.VIEW, PermissionRequired.Type.SHOWBOARD})
    @Path(value="/{spaceKey}/preview")
    @Produces(value={"text/plain"})
    @Consumes(value={"application/json"})
    public Response preview(final @PathParam(value="spaceKey") String spaceKey, final Board board) {
        return new AbstractRestResources.SpaceRestCommand(){

            @Override
            protected Response doInCommand(Space space) throws AdhocListsException {
                BoardResources.this.validateBoard(board);
                Filter filter = BoardResources.this.filterManager.get(spaceKey, board);
                BoardViewContext viewContext = new BoardViewContext(spaceKey, board.getAllKeys());
                viewContext.setPreview(true);
                ResolvedFilter resolvedFilter = BoardResources.this.filterManager.resolve(filter, viewContext);
                return Response.ok((Object)BoardResources.this.boardRenderer.renderEmbedded(viewContext, board, resolvedFilter)).build();
            }
        }.execute(spaceKey);
    }

    @POST
    @Path(value="/{contentId}/edit")
    @PermissionRequired(permissionTypes={PermissionRequired.Type.VIEW, PermissionRequired.Type.EDIT, PermissionRequired.Type.SHOWBOARD})
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public Response editBoard(@PathParam(value="contentId") long contentId, final @QueryParam(value="parent") String parent, final @QueryParam(value="filterspacekey") String filterSpaceKey, final @QueryParam(value="labels") String labels, final String boardMarkup, @QueryParam(value="id") String boardId, final @QueryParam(value="depth") String depth, final @QueryParam(value="allSpaces") boolean allSpaces) {
        return new AbstractRestResources.ContentRestCommand(){

            @Override
            protected Response doInCommand(ConfluenceEntityObject ceo) throws AdhocListsException {
                Map<String, Cards> existingCards;
                HashMap<String, Object> context = new HashMap<String, Object>();
                Board board = (Board)BoardResources.this.boardJsonSerializer.deserialize(boardMarkup);
                if (board == null) {
                    throw new AdhocListsException("Error parsing board " + boardMarkup);
                }
                Map<String, Cards> map = existingCards = ceo instanceof ContentEntityObject ? BoardResources.this.cardManager.getAllExistingCards((ContentEntityObject)ceo, board) : null;
                if (board.getFilter() == null) {
                    Filter filter = new Filter();
                    board.setFilter(filter);
                    filter.setParent(parent);
                    filter.setSpaceKey(filterSpaceKey);
                    filter.setLabels(BoardResources.this.getLabels(labels));
                    filter.setDepth(TextUtils.stringSet((String)depth) ? Integer.parseInt(depth) : 0);
                    filter.setAllSpaces(allSpaces);
                    context.put("boardMarkup", BoardResources.this.boardJsonSerializer.serialize(board));
                } else {
                    context.put("boardMarkup", boardMarkup);
                }
                String boardMarkupWithCards = existingCards != null ? BoardResources.this.makeCardBoard((String)context.get("boardMarkup"), existingCards) : null;
                int defaultMaxRows = BoardResources.this.globalConfigManager.loadGlobalConfig().getMaxBoardRows();
                context.put("board", board);
                if (StringUtils.isNotBlank((CharSequence)boardMarkupWithCards) && ((String)context.get("boardMarkup")).length() - boardMarkupWithCards.length() != 0) {
                    context.put("boardMarkupWithCards", boardMarkupWithCards);
                }
                context.put("spaceKey", this.getSpaceKey(ceo));
                context.put("filter", board.getFilter());
                context.put("styles", Styles.getInstance());
                context.put("pageFilter", true);
                context.put("globalTemplates", BoardResources.this.adhocTemplateManager.getPageTemplates(null));
                context.put("spaceTemplates", BoardResources.this.adhocTemplateManager.getPageTemplates(this.getSpaceKey(ceo)));
                context.put("defaultMaxRows", defaultMaxRows);
                String response = BoardResources.this.renderTemplateHtml("/templates/adhoclists/vm/boards/rte/editboard.vm", context);
                BoardResources.this.eventPublisher.publish((Object)new BoardDesignerOpenedEvent());
                return Response.ok((Object)response).build();
            }
        }.execute(contentId);
    }

    private void validateBoard(Board board) throws AdhocListsRestException {
        Set<BoardValidator.BoardValidationError> errors = this.boardValidator.validate(board);
        if (errors.size() > 0) {
            throw new AdhocListsRestException(Response.Status.BAD_REQUEST, errors.iterator().next().getErrorMessage());
        }
    }

    private String makeCardBoard(String boardJson, Map<String, Cards> existingCards) {
        if (existingCards.size() == 0) {
            return boardJson;
        }
        Board board = (Board)this.boardJsonSerializer.deserialize(boardJson);
        for (Board.Row row : board.getRows()) {
            for (Board.Column column : row.getColumns()) {
                for (Container container : column.getContainers()) {
                    if (!existingCards.containsKey(container.getKey())) continue;
                    List<Card> cards = existingCards.get(container.getKey()).getForStorage();
                    ArrayList cardBodies = Lists.newArrayList();
                    for (Card card : cards) {
                        if (!TextUtils.stringSet((String)card.getBody())) continue;
                        cardBodies.add(card.getBody());
                    }
                    if (cardBodies.isEmpty()) continue;
                    container.setCards(cardBodies);
                }
            }
        }
        return this.boardJsonSerializer.serialize(board);
    }

    private Card makeCardReference(String id, String title) {
        if (TextUtils.stringSet((String)id)) {
            return new Card(id, null);
        }
        if (TextUtils.stringSet((String)title)) {
            return new Card(null, title);
        }
        return null;
    }

    private Card makeCardReference(long id, String title) {
        if (id > 0L) {
            return new Card(Long.toString(id), null);
        }
        if (TextUtils.stringSet((String)title)) {
            return new Card(null, title);
        }
        return null;
    }

    public BoardSerializer getSerializer() {
        return this.boardXmlSerializer;
    }
}

