/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.lists.macro;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.opensymphony.util.TextUtils;
import java.util.Map;

public class MacroParameters {
    private Map parameters;
    private RenderContext renderContext;

    public MacroParameters(Map parameters, RenderContext renderContext) throws MacroException {
        this.parameters = parameters;
        this.renderContext = renderContext;
    }

    public String get(String[] keys, boolean mandatory) throws MacroException {
        String value = null;
        for (int i = 0; value == null && i < keys.length; ++i) {
            String key = keys[i];
            value = (String)this.parameters.get(key);
        }
        if (!TextUtils.stringSet(value) && mandatory) {
            throw new MacroException("Must provide a value for parameter " + this.getFirstParamName(keys));
        }
        return value;
    }

    private String getFirstParamName(String[] keys) {
        return keys[0].equals("0") ? "" : "'" + keys[0] + "'";
    }

    public String get(String key, boolean mandatory) throws MacroException {
        return this.get(new String[]{key}, mandatory);
    }

    public String get(String key) throws MacroException {
        return this.get(key, false);
    }

    public String get(String[] keys) throws MacroException {
        return this.get(keys, false);
    }

    public String get(String[] keys, String defaultValue) throws MacroException {
        String value = this.get(keys, false);
        return !TextUtils.stringSet((String)value) ? defaultValue : value;
    }

    public String get(String key, String defaultValue) throws MacroException {
        return this.get(new String[]{key}, defaultValue);
    }

    public int getInt(String[] keys, boolean mandatory) throws MacroException {
        String value = this.get(keys, mandatory);
        if (!TextUtils.stringSet((String)value)) {
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException var5) {
            throw new MacroException("Expected a numeric value for parameter " + this.getFirstParamName(keys) + " + but got " + value);
        }
    }

    public int getInt(String[] keys, int defaultValue) throws MacroException {
        String value = this.get(keys, false);
        if (!TextUtils.stringSet((String)value)) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException var5) {
            throw new MacroException("Expected a numeric value for parameter " + this.getFirstParamName(keys) + " + but got " + value);
        }
    }

    public int getInt(String key, int defaultValue) throws MacroException {
        return this.getInt(new String[]{key}, defaultValue);
    }

    public boolean getFlagWithDefault(String[] keys, boolean defaultValue) throws MacroException {
        String flag = this.get(keys, false);
        return !TextUtils.stringSet((String)flag) ? defaultValue : Boolean.TRUE.toString().equalsIgnoreCase(flag);
    }

    public boolean getFlagWithDefault(String key, boolean defaultValue) throws MacroException {
        return this.getFlagWithDefault(new String[]{key}, defaultValue);
    }

    public PageContext getPageContext() throws MacroException {
        if (!(this.renderContext instanceof PageContext)) {
            throw new MacroException("this macro only works within a page or blog post context");
        }
        return (PageContext)this.renderContext;
    }

    public AbstractPage getAbstractPage() throws MacroException {
        return (AbstractPage)this.getPageContext().getEntity();
    }

    public Page getPage() throws MacroException {
        AbstractPage page = this.getAbstractPage();
        if (!(page instanceof Page)) {
            throw new MacroException("this macro only works within a page");
        }
        return (Page)page;
    }
}

