/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.api;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.comalatech.confluence.adhoclists.BoardServices;
import com.comalatech.confluence.adhoclists.boards.view.BoardResolver;
import com.comalatech.confluence.adhoclists.boards.view.model.RenderedCard;
import com.comalatech.confluence.adhoclists.boards.view.model.ResolvedBoard;
import com.comalatech.confluence.adhoclists.boards.view.model.ResolvedContainer;
import com.comalatech.confluence.adhoclists.model.ResolvedFilter;
import com.comalatech.confluence.adhoclists.model.Table;
import com.comalatech.confluence.adhoclists.storage.BoardManager;
import com.comalatech.confluence.adhoclists.storage.serializer.BoardSerializer;
import com.comalatech.confluence.boards.model.Board;
import com.comalatech.confluence.boards.model.BoardViewContext;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Qualifier;

public class DefaultBoardServices
implements BoardServices {
    private BoardResolver boardResolver;
    private BoardSerializer boardSerializer;
    private BoardManager boardManager;

    public DefaultBoardServices(@Qualifier(value="labelBoardResolver") BoardResolver boardResolver, @Qualifier(value="boardJsonSerializer") BoardSerializer boardSerializer, BoardManager boardManager) {
        this.boardResolver = boardResolver;
        this.boardSerializer = boardSerializer;
        this.boardManager = boardManager;
    }

    @Override
    public List<BoardServices.Category> makeCategories(String jsonBoard) {
        Board board = (Board)this.boardSerializer.deserialize(jsonBoard);
        ResolvedBoard resolvedBoard = this.boardResolver.resolveBoard(new BoardViewContext("CEX"), new ResolvedFilter(), board);
        ArrayList<BoardServices.Category> categories = new ArrayList<BoardServices.Category>();
        for (ResolvedBoard.Row rows : resolvedBoard.getRows()) {
            for (ResolvedBoard.Column column : rows) {
                for (ResolvedContainer container : column) {
                    BoardServices.Category category = new BoardServices.Category(container.getKey(), container.getCaption(), container.getDescription());
                    List<RenderedCard> entities = container.getEntities();
                    for (RenderedCard entity : entities) {
                        ContentEntityObject ceo = entity.getContentEntityObject();
                        if (ceo == null) continue;
                        category.getPages().add((Page)ceo);
                    }
                    if (category.getPages().size() <= 0) continue;
                    categories.add(category);
                }
            }
        }
        return categories;
    }

    @Override
    public Table getBoardProperties(AbstractPage page) {
        return this.boardManager.getFromPage(page);
    }

    @Override
    public Board getBoard(AbstractPage page) {
        return (Board)this.boardManager.getFromPage(page);
    }
}

