/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

Canvas = Canvas || {};
Canvas.View = Canvas.View || {};
Canvas.View.ImportTable = Backbone.View.extend({

    className: "dialog-panel-body panel-body importtable hidden",
    id: "import-table",
    template: Canvas.Picker.importTable,
    events: {
        "keyup .textarea.newtablemarkup" : "change"
    },


    initialize: function() {
        this.render();
        this.model = new Canvas.Model.Table();
        AUI.DialogPanels.addPanel(this.$el);
        this.$markup = this.$(".newtablemarkup");
    },

    change: function() {
        this.model.set("jsonTable",this.$markup.val());
        Canvas.AppView.setChosenTable(this.model);
    },

    select: function() {
        AUI.DialogPanels.selectPanel(this.$el);
        Canvas.AppView.setChosenTable(this.model,true);
        Canvas.AppView.history.navigate('board/' + this.id);
    },

    render: function() {
        this.$el.html(this.template());
        return this;
    }

});