/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

Canvas = Canvas || {};
Canvas.View = Canvas.View || {};
Canvas.View.FilterDialog = Backbone.View.extend({
    model: Canvas.Model.Filter,
    tagName: "form",
    className: "aui",

    template: Canvas.Picker.filterDialog,

    events: {
        "change input.filterlabels" : "changeLabels",
        "change input.filterparent" : "changeParent",
        "change input.filterspace" : "changeSpace",
        "change input.filterdepth" : "changeDepth"
    },

    initialize: function() {
        this.model.on("error",this.error,this);
        this.model.on("change",this.change,this);
    },

    render: function() {
        this.$el.html(this.template({filter: this.model.attributes}));
        return this;
    },

    error: function(model, errors) {
        _.each(errors,function(error) {
            this.$(".filter-" + error.field + " .error").html(error.message);
        },this);
        // todo: disable buttons
    },

    change: function(model) {
        this.$(".error").html("");
    },

    changeLabels: function(event) {
        this.model.set("labels",AJS.$(event.target).val());
    },

    changeParent: function(event) {
        this.model.set("parent",AJS.$(event.target).val());
    },

    changeSpace: function(event) {
        this.model.set("spaceKey",AJS.$(event.target).val());
    },

    changeDepth: function(event) {
        this.model.set("depth",AJS.$(event.target).val());
    }
});
