/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

Canvas = Canvas || {};
Canvas.Collection = Canvas.Collection || {};
Canvas.Collection.Categories = Backbone.Collection.extend({
    model: Canvas.Model.Category,

    initialize: function(url, exchange) {
        this.baseUrl = url;
        if (exchange) {
            this.exchange = true;
            this.url = this.baseUrl
        } else {
            this.url = this.baseUrl + "?blueprint=" + Canvas.CML.blueprint +
                    (Canvas.CML.spaceKey ? "&spaceKey=" + Canvas.CML.spaceKey : "");
        }
    }
});