/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.boards.service;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.labels.Label;
import com.comalatech.confluence.adhoclists.model.ResolvedFilter;
import com.comalatech.confluence.boards.rest.model.PageBasicInfo;
import com.comalatech.confluence.boards.service.BoardCqlSearchService;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BoardCqlSearchServiceImpl
implements BoardCqlSearchService {
    private final CQLSearchService cqlSearchService;

    @Autowired
    public BoardCqlSearchServiceImpl(CQLSearchService cqlSearchService) {
        this.cqlSearchService = cqlSearchService;
    }

    @Override
    public List<PageBasicInfo> searchPagesByTitleAndFilter(String searchText, ResolvedFilter boardFilter, boolean searchAllSpaces) {
        if (searchText.length() >= MIN_CHARS_FOR_TITLE_SEARCH) {
            PageResponse pageResponse;
            String cqlQuery = this.generatePageSearchCqlByTitleAndFilter(searchText, boardFilter, searchAllSpaces);
            int depth = boardFilter.getDepth();
            if (!boardFilter.isAllSpaces() && boardFilter.getParentPage() != null && depth > 0) {
                pageResponse = this.cqlSearchService.searchContent(cqlQuery, (PageRequest)new SimplePageRequest(0, MAX_PAGE_SEARCH_RESULTS.intValue()), new Expansion[]{new Expansion("ancestors")});
                depth = boardFilter.getParentPage() != null && boardFilter.getParentPage().getAncestors() != null ? depth + boardFilter.getParentPage().getAncestors().size() : depth;
            } else {
                pageResponse = this.cqlSearchService.searchContent(cqlQuery, (PageRequest)new SimplePageRequest(0, MAX_PAGE_SEARCH_RESULTS.intValue()), new Expansion[0]);
            }
            return this.filterAndTransformContentSearchResults(depth, (PageResponse<Content>)pageResponse);
        }
        return Collections.emptyList();
    }

    private List<PageBasicInfo> filterAndTransformContentSearchResults(int depth, PageResponse<Content> pageResponse) {
        return pageResponse.getResults().stream().filter(content -> depth == 0 || depth >= content.getAncestors().size()).map(content -> new PageBasicInfo(content.getId().serialise(), content.getTitle())).collect(Collectors.toList());
    }

    private String generatePageSearchCqlByTitleAndFilter(String searchText, ResolvedFilter boardFilter, boolean searchAllSpaces) {
        StringBuilder cqlQuery = new StringBuilder("type = page AND title ~ \"" + searchText + "*\"");
        if (!boardFilter.isAllSpaces() && boardFilter.getParentPage() != null) {
            cqlQuery.append(" AND ancestor = " + boardFilter.getParentPage().getId());
        } else if (!(boardFilter.isAllSpaces() && searchAllSpaces || !StringUtils.isNotBlank((CharSequence)boardFilter.getSpaceKey()))) {
            cqlQuery.append(" AND space.key = \"" + boardFilter.getSpaceKey() + "\"");
        }
        cqlQuery.append(this.generateLabelFilter(boardFilter.getLabelsList()));
        return cqlQuery.toString();
    }

    private String generateLabelFilter(List<Label> labels) {
        StringBuilder condition = new StringBuilder();
        for (Label label : labels) {
            condition.append(" AND label = \"" + label.toString() + "\"");
        }
        return condition.toString();
    }
}

