/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.storage;

import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.persistence.AnyTypeDao;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.comalatech.confluence.adhoclists.content.ComalaPropertiesSetManager;
import com.comalatech.confluence.adhoclists.model.Table;
import com.comalatech.confluence.adhoclists.storage.AbstractTableManager;
import com.comalatech.confluence.adhoclists.storage.BoardManager;
import com.comalatech.confluence.adhoclists.storage.BoardModuleDescriptor;
import com.comalatech.confluence.adhoclists.storage.serializer.BoardJsonSerializer;
import com.comalatech.confluence.adhoclists.storage.serializer.BoardXmlSerializer;
import com.comalatech.confluence.adhoclists.storage.serializer.MockBoardSerializer;
import com.comalatech.confluence.boards.model.Board;
import com.comalatech.confluence.boards.model.Container;
import com.comalatech.confluence.boards.model.MockBoard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBoardManager
extends AbstractTableManager<Board>
implements BoardManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultBoardManager.class);
    private BoardXmlSerializer boardXmlSerializer;
    private BoardJsonSerializer boardJsonSerializer;
    private MockBoardSerializer mockBoardSerializer;

    public DefaultBoardManager(BandanaManager bandanaManager, TransactionTemplate transactionTemplate, PluginAccessor pluginAccessor, ComalaPropertiesSetManager contentPropertyManager, SearchManager searchManager, AnyTypeDao anyTypeDao, PageManager pageManager, XhtmlContent xhtmlContent, BoardXmlSerializer boardXmlSerializer, BoardJsonSerializer boardJsonSerializer, MockBoardSerializer mockBoardSerializer) {
        super(bandanaManager, transactionTemplate, pluginAccessor, contentPropertyManager, searchManager, anyTypeDao, pageManager, xhtmlContent);
        this.boardXmlSerializer = boardXmlSerializer;
        this.boardJsonSerializer = boardJsonSerializer;
        this.mockBoardSerializer = mockBoardSerializer;
    }

    @Override
    public Board deserialize(String body) {
        try {
            return (Board)this.boardXmlSerializer.deserialize(body);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    @Override
    public String serialize(Board board) {
        return this.boardXmlSerializer.serialize(board);
    }

    @Override
    public Board deserializeJson(String body) {
        try {
            return (Board)this.boardJsonSerializer.deserialize(body);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    @Override
    public String serializeJson(Board template) {
        return this.boardJsonSerializer.serialize(template);
    }

    @Override
    protected String serializeMock(Table mock) {
        return this.mockBoardSerializer.serialize((MockBoard)mock);
    }

    @Override
    protected Table deserializeMock(String mock) {
        return this.mockBoardSerializer.deserialize(mock);
    }

    @Override
    protected Class getDescriptorClass() {
        return BoardModuleDescriptor.class;
    }

    @Override
    public String getBandanaKey() {
        return "adhoclists.templates.boards";
    }

    @Override
    public String getMacroName() {
        return "adhocboard";
    }

    @Override
    public Board makeEmpty() {
        Board board = new Board(ConfluenceActionSupport.getTextStatic((String)"adhoclists.rte.boards.select.new"), Board.Type.LABEL);
        board.setDescription(ConfluenceActionSupport.getTextStatic((String)"adhoclists.rte.boards.select.new.description"));
        board.addRow().addColumn().add(new Container());
        return board;
    }

    @Override
    protected String getDefaultNewTableName() {
        return ConfluenceActionSupport.getTextStatic((String)"adhoclists.rte.boards.select.new");
    }
}

