/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.boards.view.model;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.adhoclists.cards.model.ResolvedCard;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="card")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RenderedCard
extends ResolvedCard {
    private boolean readOnly;
    private boolean visible;
    private ContentEntityObject contentEntityObject;
    private String bodyHtml;
    private String contentHtml;
    private String elementId;

    public RenderedCard() {
    }

    public RenderedCard(String id, String title, String url) {
        super(id, title, url);
        this.elementId = "cardid-" + id;
        this.visible = true;
    }

    public RenderedCard(ResolvedCard card) {
        super(card);
        this.elementId = "cardid-" + Integer.toHexString(card.hashCode());
        this.visible = true;
    }

    public RenderedCard(AbstractPage page, boolean visible) {
        this(page.getIdAsString(), page.getTitle(), page.getUrlPath());
        this.contentEntityObject = page;
        this.visible = visible;
    }

    public RenderedCard(AbstractPage page) {
        this(page, true);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isVisible() {
        return this.visible;
    }

    protected void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof RenderedCard) {
            RenderedCard other = (RenderedCard)o;
            return this.getId().equals(other.getId()) && this.getTitle().equals(other.getTitle()) && this.getUrl().equals(other.getUrl()) && this.readOnly == other.readOnly;
        }
        return false;
    }

    public ContentEntityObject getContentEntityObject() {
        return this.contentEntityObject;
    }

    protected void setContentEntityObject(ContentEntityObject contentEntityObject) {
        this.contentEntityObject = contentEntityObject;
    }

    public String getBodyHtml() {
        return this.bodyHtml;
    }

    public void setBodyHtml(String bodyHtml) {
        if (bodyHtml != null && !this.cleanHtml(bodyHtml).equals(this.getBody())) {
            this.bodyHtml = bodyHtml;
        }
    }

    public String getElementId() {
        return this.elementId;
    }

    protected void setElementId(String elementId) {
        this.elementId = elementId;
    }

    public String getContentHtml() {
        return this.contentHtml;
    }

    public void setContentHtml(String contentHtml) {
        if (!this.cleanHtml(contentHtml).equals(this.getContent())) {
            this.contentHtml = contentHtml;
        }
    }

    protected String cleanHtml(String text) {
        if (text != null && text.indexOf("<p>") == 0) {
            return text.substring(3, text.length() - 4);
        }
        return text;
    }
}

