/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.analytics;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.core.ConfluenceSidManager;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.comalatech.confluence.adhoclists.analytics.AbstractBoardsAnalyticsManager;
import com.comalatech.confluence.analytics.StatField;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluationAnalyticsManager
extends AbstractBoardsAnalyticsManager {
    private static final Logger log = LoggerFactory.getLogger(EvaluationAnalyticsManager.class);
    public static final String STAT_APP_SEN = "appSen";
    public static final String STAT_CONFLUENCE_SEN = "hostSen";

    public EvaluationAnalyticsManager(BandanaManager bandanaManager, ConfluenceSidManager confluenceSidManager, SystemInformationService systemInformationService, PluginAccessor pluginAccessor, PluginLicenseManager pluginLicenseManager, SearchManager searchManager) {
        super(bandanaManager, confluenceSidManager, systemInformationService, pluginAccessor, pluginLicenseManager, searchManager);
    }

    public boolean showDisableAnalyticsToggleButton() {
        return false;
    }

    public boolean isEnabled() {
        return true;
    }

    public StatField[] getDefaultStatFields() {
        return new StatField[]{new StatField("timestamp", () -> new Date().getTime()), new StatField("app", () -> this.getFriendApps().getOrDefault(this.pluginLicenseManager.getPluginKey(), "---")), new StatField("version", () -> this.pluginAccessor.getPlugin(this.pluginLicenseManager.getPluginKey()).getPluginInformation().getVersion()), new StatField(STAT_APP_SEN, () -> this.getAppSupportEntitlementNumber()), new StatField(STAT_CONFLUENCE_SEN, () -> this.getConfluenceSupportEntitlementNumber())};
    }

    public void resolveAnalytics() {
        if (!this.isEnabled()) {
            log.debug("resolveAnalytics not running as it's disabled");
            return;
        }
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        Arrays.stream(this.getStatFields()).forEach(f -> valuesMap.put(f.getName(), (String)f.getProcessor().execute()));
        Arrays.asList(STAT_APP_SEN, STAT_CONFLUENCE_SEN, "timestamp", "app", "version").forEach(field -> {
            if (!valuesMap.containsKey(field)) {
                throw new RuntimeException("No <" + field + "> field in provided statFields: it's mandatory");
            }
        });
        String token = "{ \"appSen\": \"" + valuesMap.get(STAT_APP_SEN) + "\", \"hostSen\": \"" + valuesMap.get(STAT_CONFLUENCE_SEN) + "\", \"timestamp\": \"" + valuesMap.get("timestamp") + "\" }";
        String signature = this.encrypt(token);
        valuesMap.put("comalatechToken", signature);
        this.bandanaManager.setValue((BandanaContext)this.getBandanaContext(), this.BANDANA_STATS_KEY, valuesMap);
        if (log.isDebugEnabled()) {
            log.debug("Recalculated stats: " + valuesMap);
        }
    }

    private String getAppSupportEntitlementNumber() {
        String appSEN = "---";
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            appSEN = (String)((PluginLicense)this.pluginLicenseManager.getLicense().get()).getSupportEntitlementNumber().orElse(Option.option((Object)"---")).get();
        }
        return appSEN;
    }

    private String getConfluenceSupportEntitlementNumber() {
        String hostSEN = "---";
        if (this.systemInformationService.getConfluenceInfo() != null) {
            hostSEN = this.systemInformationService.getConfluenceInfo().getSupportEntitlementNumber() == null ? "---" : this.systemInformationService.getConfluenceInfo().getSupportEntitlementNumber();
        }
        return hostSEN;
    }
}

