/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

Canvas = Canvas || {};
Canvas.View = Canvas.View || {};
Canvas.View.TableListing = Backbone.View.extend({
    model: Canvas.Model.Table,
    className: "tablelisting",
    template: Canvas.Picker.tableListing,

    events: {
        click: "select"
    },

    initialize: function(options) {
        this.categoryName = options.category;

        if (this.model.get("id") == -1) {
            this.view = new Canvas.View.ImportTable({});
        } else if (this.model.get("wizard")) {
            var w = this.model.get("wizard");

            if(Canvas.HACK_NXMBoards && w == 'Roadmap') {
                w = 'NxMBoard';
            }
            this.view = new Canvas.View.Wizard({wizard: w});
        } else {
            this.view = new Canvas.View.SelectedTable({model: this.model});
        }
        Confluence.Binder.autocompleteUser();
    },

    select: function() {
        this.view.select();
        if (this.model.collection && this.model.collection.exchange) {
            Canvas.CML.analytics.trackPage('category/' + this.categoryName + '/' + this.model.get("name"));
        }
    },

    render: function() {
        this.$el.html(this.template(this.model.attributes));
        return this;
    }

});