/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

Canvas = Canvas || {};
Canvas.View = Canvas.View || {};
Canvas.View.BoardPropertiesDialog = Backbone.View.extend({

    model: Canvas.Model.Board,
    tagName: "form",
    className: "aui",
    template: Canvas.Picker.boardProperties,

    events: {
        "change input.name" : "changeName",
        "change select.contenttype" : "changeContentType",
        "change select.matchheights" : "changeHeightsMatching",
        "change input.boardcentered" : "changeBoardCentered",
        "change input.boardnotifications" : "changeBoardNotifications",
        "change input.hideboarddescriptions" : "changeHideBoardDescriptions"
    },

    render: function() {
        this.$el.html(this.template({board: this.model.attributes}));
        return this;
    },

    changeName: function(event) {
        this.model.set("name",AJS.$(event.target).val());
    },

    changeContentType: function(event) {
        var selected = AJS.$(event.target).val();
        if (selected == "cardsonly") {
            this.model.set({
                cardsOnlyBoard: true,
                pagesOnlyBoard: false
            });
        } else if (selected == "pagesonly") {
            this.model.set({
                cardsOnlyBoard: false,
                pagesOnlyBoard: true
            });
        } else {
            this.model.set({
                cardsOnlyBoard: false,
                pagesOnlyBoard: false
            });
        }
    },

    changeHeightsMatching: function(event) {
        var selected = AJS.$(event.target).val();
        if (selected == "matchrowheights") {
            this.model.set({
                matchRowHeight: true,
                matchHeight: false
            });
        } else if (selected == "matchallheights") {
            this.model.set({
                matchRowHeight: false,
                matchHeight: true
            });
        } else {
            this.model.set({
                matchRowHeight: false,
                matchHeight: false
            });
        }
    },

    changeBoardCentered: function(event) {
        this.model.set("leftJustified",! AJS.$(event.target).is(":checked"));
    },

    changeBoardNotifications: function(event) {
        this.model.set("boardNotifications",AJS.$(event.target).is(":checked"));
    },

    changeHideBoardDescriptions : function(event){
        this.model.set("hideDescriptions", AJS.$(event.target).is(":checked"));
    }

});