/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

/**
 * Represents a Board or a List listing.
 * @type {*}
 */
var Canvas = Canvas || {};
Canvas.Model = Canvas.Model || {};
Canvas.Model.Table = Backbone.Model.extend({

    defaults: {
        filter : new Canvas.Model.Filter()
    },

    initialize: function() {
        if (this.collection) {
            if (this.get("spaceKey")) {
                this.url = this.collection.baseUrl + "/" + this.get("spaceKey") + "/" + this.get("id");
            } else {
                this.url = this.collection.baseUrl + "/" + this.get("id");
            }
        }
        this.bind("change",this.loadTable,this);
        if (window.parent && window.parent.Canvas && window.parent.Canvas.filter) {
            this.set({filter: new Canvas.Model.Filter(window.parent.Canvas.filter)});
        }
        this.adjustMock();
    },

    /**
     * Adjust the mock board to make it nice looking :)
     */
    adjustMock: function() {
        if (! this.get("mock")) {
            return;
        }
        var CONTAINER_HEIGHT = 20;
        var CONTAINER_SEPARATOR = 2;
        var mock = this.get("mock");
        _.each(mock.rows,function(row) {
            var max = 0;
            _.each(row,function(column) {
                max = column.length > max ? column.length : max;
            });
            var maxHeight = (max * CONTAINER_HEIGHT) + (max - 1) * CONTAINER_SEPARATOR;
            _.each(row,function(column) {
                var containerHeight;
                var extra = 0;
                if (column.length == max) {
                    containerHeight = CONTAINER_HEIGHT;
                } else {
                    containerHeight = CONTAINER_HEIGHT * max / column.length +
                            CONTAINER_SEPARATOR * (max - 1) / column.length;
                    extra = maxHeight - (containerHeight * column.length);
                }
                _.each(column,function(container) {
                    container.height = containerHeight + extra;
                    extra = 0;
                });
            });
        });
    },

    // This handler will set the table object by parsing the jsonTable (string) provided by CEX
    // Note that sample boards, are provided a
    // s formal objects whereas CEX returns the JSON representation
    loadTable: function() {
        var parsedJSON = '';
        
        if (this.hasChanged("jsonTable")) {
            try {
                parsedJSON = AJS.$.parseJSON(this.get("jsonTable"));
            }
            catch(e) {
                // JSON format not well formed
            }
            
            // set/unset only if jsonTable has valid JSON format and can be parsed
            if(parsedJSON) {
                this.set("board", new Canvas.Model.Board(parsedJSON, {silent: true}));
                this.unset("jsonTable", {silent: true});
                this.get("board").change();
            }
        } else if (this.get("table")) {
            this.set("board",new Canvas.Model.Board(this.get("table")),{silent: true});
            this.unset("table",{silent: true});
            this.get("board").change();
        }
    }
});

