/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.boards.collector;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.comalatech.confluence.adhoclists.storage.DefaultBoardManager;
import com.comalatech.confluence.boards.model.Board;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class NewBoardCollectorAction
extends AbstractSpaceAction {
    private final DefaultBoardManager boardManager;
    private final PageManager pageManager;
    private List<String> boards;

    public NewBoardCollectorAction(DefaultBoardManager boardManager, PageManager pageManager) {
        this.boardManager = boardManager;
        this.pageManager = pageManager;
    }

    public String doViewBoardCollection() {
        this.boards = this.boardManager.getSpaceTables(this.getHelper().getSpaceKey()).stream().map(board -> {
            AbstractPage page = this.pageManager.getAbstractPage(board.getId());
            if (page != null) {
                return "{ \"pageId\": " + board.getId() + ", \"url\": \"" + page.getUrlPath() + "\", \"title\": \"" + page.getTitle() + "\", \"board\": " + this.boardManager.serializeJson((Board)board.getTable()) + " }";
            }
            return "";
        }).filter(boardInfo -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{boardInfo})).collect(Collectors.toList());
        return "success";
    }

    public List<String> getBoards() {
        return this.boards;
    }
}

