/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.analytics;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.spring.container.ContainerManager;
import com.comalatech.confluence.analytics.AnalyticsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AnalyticsGatheringJob
implements JobRunner {
    private static final Logger log = LoggerFactory.getLogger(AnalyticsGatheringJob.class);
    protected TransactionTemplate transactionTemplate;
    protected AnalyticsManager analyticsManager;

    public AnalyticsGatheringJob(@ComponentImport TransactionTemplate transactionTemplate, AnalyticsManager analyticsManager) {
        this.transactionTemplate = transactionTemplate;
        this.analyticsManager = analyticsManager;
    }

    public JobRunnerResponse runJob(JobRunnerRequest request) {
        log.debug("AnalyticsGatheringJob starting");
        if (request.isCancellationRequested()) {
            return JobRunnerResponse.aborted((String)"Job cancelled.");
        }
        try {
            if (this.analyticsManager.canResolveAnalytics()) {
                ContainerManager.autowireComponent((Object)this);
                this.transactionTemplate.execute(() -> {
                    this.analyticsManager.resolveAnalytics();
                    return null;
                });
            }
        }
        catch (Exception e) {
            log.error("Generic exception at AnalyticsGatheringJob", (Throwable)e);
            e.printStackTrace();
        }
        catch (Error e) {
            log.error("Generic error at AnalyticsGatheringJob", (Throwable)e);
            e.printStackTrace();
        }
        return JobRunnerResponse.success((String)"Job finished successfully.");
    }
}

