/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.lists.accessor;

import com.comalatech.confluence.adhoclists.lists.accessor.LabelValueAccessor;
import com.comalatech.confluence.adhoclists.lists.accessor.MetadataValueAccessor;
import com.comalatech.confluence.adhoclists.lists.accessor.MutallyExclusiveLabelsAccessor;
import com.comalatech.confluence.adhoclists.lists.accessor.PageValueAccessor;
import com.comalatech.confluence.adhoclists.lists.accessor.TaskValueAccessor;
import com.comalatech.confluence.adhoclists.lists.accessor.ValueAccessor;
import com.comalatech.confluence.adhoclists.lists.accessor.WikiValueAccessor;
import com.comalatech.confluence.adhoclists.lists.model.Column;
import com.comalatech.confluence.adhoclists.lists.model.LabelValueType;
import com.comalatech.confluence.adhoclists.lists.model.MetadataValueType;
import com.comalatech.confluence.adhoclists.lists.model.MutuallyExclusiveLabelsValueType;
import com.comalatech.confluence.adhoclists.lists.model.PageValueType;
import com.comalatech.confluence.adhoclists.lists.model.TaskValueType;
import com.comalatech.confluence.adhoclists.lists.model.WikiValueType;
import com.comalatech.confluence.adhoclists.utils.PluginContainerManager;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

public class AccessorFactory {
    private static final Map<Class, Class> ACCESSORS = new HashMap<Class, Class>();

    public static ValueAccessor makeValueAccessor(Column column) {
        try {
            Class accessorClass = ACCESSORS.get(column.getValueType().getClass());
            Constructor<?>[] constructor = accessorClass.getConstructors();
            ValueAccessor valueAccessor = (ValueAccessor)constructor[0].newInstance(column);
            PluginContainerManager.autowireComponent(valueAccessor);
            return valueAccessor;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not retrieve accessor for " + column);
        }
    }

    static {
        ACCESSORS.put(LabelValueType.class, LabelValueAccessor.class);
        ACCESSORS.put(MetadataValueType.class, MetadataValueAccessor.class);
        ACCESSORS.put(MutuallyExclusiveLabelsValueType.class, MutallyExclusiveLabelsAccessor.class);
        ACCESSORS.put(PageValueType.class, PageValueAccessor.class);
        ACCESSORS.put(WikiValueType.class, WikiValueAccessor.class);
        ACCESSORS.put(TaskValueType.class, TaskValueAccessor.class);
    }
}

