/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var Canvas = Canvas || {};
Canvas.Wizard = Canvas.Wizard || {};
Canvas.Wizard.Roadmap = Backbone.View.extend({

    template: Canvas.WizardTemplates.roadmapCanvas,
    events: {
        "focus input" : "focus"
    },

    initialize: function() {
        this.render();
        this.$versions = [this.$("#version1"),this.$("#version2"),this.$("#version3"),this.$("#version4")];
        this.$etas = [this.$("#eta1"),this.$("#eta2"),this.$("#eta3"),this.$("#eta4")];
        this.$error = this.$(".error");
    },

    focus: function(event) {
        this.clearError();
    },

    clearError: function() {
        this.$error.html("");
    },

    error: function(message) {
        this.$error.html(message);
    },

    convertToLabel: function(input) {
        var specialCharacter = /[\s:;\.?&\[\]\(\)#\^!<>~\*]+/g; // allowing the @ character deliberately
        var lo = input.toLowerCase();
        return lo.replace(specialCharacter, '')
    },

    makeBoard: function() {
        var versions = this.makeVersions();
        if (versions.length < 2) {
            this.error(AJS.I18n.getText("canvas.blueprint.roadmap.error.no-rows"));
            return;
        }
        var featuresRow = {
            header: "Features",
            column: []
        };
        var marketingRow = {
            header: "Marketing",
            column: []
        };
        _.each(versions,function(version) {
            var label = this.convertToLabel(version.version);
            featuresRow.column.push({
                header: version.version,
                container: [{
                    key: "features,"+ label,
                    caption: version.eta,
                    style: "s001"
                }]
            });
            marketingRow.column.push({
                container: [{
                    key: "marketing," + label,
                    caption: " ",
                    style: "s002"
                }]
            });
        },this);
        var ideasRow = {
            column: [{
                container: [{
                    key: "ideas",
                    caption: "Ideas"
                }]
            },{
                container: [{
                    key: "rejected",
                    caption: "Rejected"
                }]
            }
            ]
        };
        var board = {
                name: "Product Roadmap",
                type: "LABEL",
                matchRowHeight: true,
                cardsOnlyBoard: true,
                "row": [
                    featuresRow,marketingRow,ideasRow
                ]
        };
        return new Canvas.Model.Board(board);
    },

    makeVersions: function() {
        var versions = [];
        for (var i = 0; i < this.$versions.length;i++) {
            if (this.$versions[i].val().length > 0) {
                if (this.$etas[i].val().length > 0) {
                    versions.push({
                        version: this.$versions[i].val(),
                        eta: this.$etas[i].val()
                    });
                }
            }
        }
        return versions;
    },

    render: function() {
        this.$el.html(this.template({}));
        return this;
    }

});