/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.utils;

import com.atlassian.confluence.search.v2.ContentSearch;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchSort;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentSearchConfluence8CompatibilityBuilder {
    private static final Logger log = LoggerFactory.getLogger(ContentSearchConfluence8CompatibilityBuilder.class);

    public ContentSearch getContentSearch(SearchQuery query, SearchSort sort) {
        try {
            Class<?> contentSearchClass = Class.forName("com.atlassian.confluence.search.v2.ContentSearch");
            Class[] constructorTypes = new Class[]{SearchQuery.class, SearchSort.class};
            Constructor<?> contentSearchClassConstructor = contentSearchClass.getConstructor(constructorTypes);
            Object[] constructorArgs = new Object[]{query, sort};
            Object newContentSearchClassInstance = contentSearchClassConstructor.newInstance(constructorArgs);
            return (ContentSearch)newContentSearchClassInstance;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            log.error("Error detected while building ContentSearch object through compatibility layer", (Throwable)e);
            return null;
        }
    }
}

