/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.rest;

import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.sal.api.message.I18nResolver;
import com.comalatech.confluence.adhoclists.boards.BoardValidator;
import com.comalatech.confluence.adhoclists.condition.RestCondition;
import com.comalatech.confluence.adhoclists.filter.FilterManager;
import com.comalatech.confluence.adhoclists.model.Table;
import com.comalatech.confluence.adhoclists.rest.AbstractRestResources;
import com.comalatech.confluence.adhoclists.rest.model.TableListing;
import com.comalatech.confluence.adhoclists.storage.TableManager;
import com.comalatech.confluence.adhoclists.storage.serializer.Serializer;
import com.comalatech.confluence.adhoclists.templates.AdhocTemplateManager;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractExchangeServices<T extends Table>
extends AbstractRestResources<T> {
    protected static final String CATEGORY_BUNDLED = "bundled-table";
    protected static final String CATEGORY_SEARCH = "search-table";
    protected static final String CATEGORY_WIZARD = "wizard-table";
    private Serializer<T> serializer;
    protected TableManager<T> tableManager;

    public AbstractExchangeServices(PageManager pageManager, SpaceManager spaceManager, PermissionManager permissionManager, LabelManager labelManager, FilterManager filterManager, ContentEntityManager contentEntityManager, AdhocTemplateManager adhocTemplateManager, PageTemplateManager pageTemplateManager, I18nResolver i18nResolver, RestCondition restCondition, BoardValidator boardValidator, Serializer<T> serializer, TableManager<T> tableManager) {
        super(pageManager, spaceManager, permissionManager, labelManager, filterManager, contentEntityManager, adhocTemplateManager, pageTemplateManager, i18nResolver, restCondition, boardValidator);
        this.serializer = serializer;
        this.tableManager = tableManager;
    }

    public abstract TableManager.TableDescriptor<T> makeEmptyTableDescriptor();

    public abstract TableManager.TableDescriptor<T> makeImportTableDescriptor();

    protected List<TableListing> getListings(String category, String spaceKey, boolean includeWizards) {
        if (CATEGORY_BUNDLED.equals(category)) {
            ArrayList<TableManager.TableDescriptor<T>> descriptors = new ArrayList<TableManager.TableDescriptor<T>>();
            if (includeWizards) {
                descriptors.add(this.makeEmptyTableDescriptor());
            }
            descriptors.addAll(this.tableManager.getBundledDescriptors(includeWizards));
            if (includeWizards) {
                descriptors.add(this.makeImportTableDescriptor());
            }
            return this.makeListings(descriptors, false);
        }
        if (CATEGORY_WIZARD.equals(category)) {
            return this.makeListings(this.tableManager.getBundledDescriptors(true), true);
        }
        if (CATEGORY_SEARCH.equals(category)) {
            List<TableManager.TableDescriptor<T>> descriptors = this.tableManager.getAllDescriptors(spaceKey);
            return this.makeListings(descriptors, false);
        }
        return this.makeListings(this.tableManager.getAllDescriptors(category), false);
    }

    private List<TableListing> makeListings(List<TableManager.TableDescriptor<T>> descriptors, boolean wizardsOnly) {
        ArrayList<TableListing> tables = new ArrayList<TableListing>();
        for (TableManager.TableDescriptor<T> descriptor : descriptors) {
            if (wizardsOnly && descriptor.getWizard() == null) continue;
            TableListing listing = new TableListing(descriptor.getId(), descriptor.getSpaceKey(), descriptor.getName());
            if (descriptor.getTable() != null) {
                listing.setMock(descriptor.getTable().toMock());
            }
            listing.setWizard(descriptor.getWizard());
            tables.add(listing);
        }
        return tables;
    }

    protected T getTable(String category, String spaceKey, long id) {
        Table table = null;
        if (CATEGORY_BUNDLED.equals(category)) {
            if (id == 0L) {
                return this.tableManager.makeEmpty();
            }
            return this.tableManager.getBundled(id);
        }
        if (spaceKey != null) {
            List<String> names = this.tableManager.getNames(spaceKey);
            for (String name : names) {
                if ((long)name.hashCode() != id) continue;
                table = this.tableManager.get(spaceKey, name);
            }
        } else {
            table = (Table)this.tableManager.getFromPage(id);
        }
        if (table != null) {
            table.clear();
        }
        return (T)table;
    }

    @Override
    public Serializer<T> getSerializer() {
        return this.serializer;
    }
}

