/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.module;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.comalatech.confluence.adhoclists.license.AdhocLicenseManager;
import com.comalatech.confluence.adhoclists.model.GlobalConfig;
import com.comalatech.confluence.adhoclists.module.GlobalConfigManager;
import com.comalatech.confluence.adhoclists.storage.AdhocListManager;
import com.google.common.collect.Maps;
import com.opensymphony.util.TextUtils;
import java.util.Map;
import org.springframework.beans.factory.annotation.Qualifier;

public class GlobalConfigManagerImpl
implements GlobalConfigManager {
    static final String BANDANA_SUFFIX = ".checklistConfig";
    static final String MAX_BOARD_ROWS = ".maxboardrows";
    static final String MAX_LIST_ROWS = ".maxrows";
    static final String NOTIFY_OWN_ACTIONS = ".notifyownactions";
    static final String NO_STATS = ".nostats";
    static final String SHOW_HIDE = ".showhide";
    static final String METADATA_ACCESSOR = ".metadataaccessor";
    static final String METADATA_ACCESSOR_NAME = ".metadataaccessorname";
    public static final String SHOW_BOARD_SPACES = ".showBoardSpaces";
    public static final String HIDE_BOARD_SPACES = ".hideBoardSpaces";
    public static final String SHOW_LIST_SPACES = ".showListSpaces";
    public static final String HIDE_LIST_SPACES = ".hideListSpaces";
    public static final String GLOBAL_CONFIG_CACHE_KEY = "globalConfig";
    private AdhocListManager adhocListManager;
    private BandanaManager bandanaManager;
    private final AdhocLicenseManager licenseManager;
    private TransactionTemplate transactionTemplate;
    private final Cache cache;
    private ConfluenceBandanaContext confluenceBandanaContext = new ConfluenceBandanaContext();

    public GlobalConfigManagerImpl(AdhocListManager adhocListManager, BandanaManager bandanaManager, AdhocLicenseManager licenseManager, @Qualifier(value="cacheFactory") CacheFactory cacheFactory, TransactionTemplate transactionTemplate) {
        this.adhocListManager = adhocListManager;
        this.bandanaManager = bandanaManager;
        this.licenseManager = licenseManager;
        this.transactionTemplate = transactionTemplate;
        this.cache = cacheFactory.getCache(this.getBandanaKey(".cache"));
    }

    @Override
    public void storeGlobalConfig(GlobalConfig config) {
        this.transactionTemplate.execute(() -> {
            this.cache.removeAll();
            this.bandanaManager.setValue((BandanaContext)this.confluenceBandanaContext, this.getBandanaKey(MAX_BOARD_ROWS), (Object)config.getMaxBoardRows());
            this.bandanaManager.setValue((BandanaContext)this.confluenceBandanaContext, this.getBandanaKey(MAX_LIST_ROWS), (Object)config.getMaxListRows());
            this.bandanaManager.setValue((BandanaContext)this.confluenceBandanaContext, this.getBandanaKey(NOTIFY_OWN_ACTIONS), (Object)config.isNotifyOwnChanges());
            this.bandanaManager.setValue((BandanaContext)this.confluenceBandanaContext, this.getBandanaKey(NO_STATS), (Object)config.isNoStats());
            this.bandanaManager.setValue((BandanaContext)this.confluenceBandanaContext, this.getBandanaKey(SHOW_HIDE), config.getShowHideMap());
            this.bandanaManager.setValue((BandanaContext)this.confluenceBandanaContext, this.getBandanaKey(METADATA_ACCESSOR_NAME), (Object)config.getMetadataAccessorType().name());
            return null;
        });
    }

    @Override
    public GlobalConfig loadGlobalConfig() {
        Object config = this.cache.get((Object)GLOBAL_CONFIG_CACHE_KEY);
        if (!(config instanceof GlobalConfig)) {
            config = this.transactionTemplate.execute(() -> {
                GlobalConfig config1 = this.buildNewConfiguration();
                this.cache.put((Object)GLOBAL_CONFIG_CACHE_KEY, (Object)config1);
                return config1;
            });
        }
        return (GlobalConfig)config;
    }

    private String getBandanaKey(String element) {
        return this.adhocListManager.getBandanaKey() + BANDANA_SUFFIX + element;
    }

    private GlobalConfig buildNewConfiguration() {
        ConfigBuilder builder = new ConfigBuilder();
        builder.setMaxBoardRows().setMaxListRows().setShowHideMap().setMetadataAccessor().setNotifyOwnActions().setNoStats();
        return builder.build();
    }

    private class ConfigBuilder {
        private GlobalConfig config = new GlobalConfig();

        public ConfigBuilder setMaxBoardRows() {
            Integer maxBoardRows = (Integer)GlobalConfigManagerImpl.this.bandanaManager.getValue((BandanaContext)GlobalConfigManagerImpl.this.confluenceBandanaContext, GlobalConfigManagerImpl.this.getBandanaKey(GlobalConfigManagerImpl.MAX_BOARD_ROWS));
            if (maxBoardRows != null) {
                this.config.setMaxBoardRows(maxBoardRows);
            }
            return this;
        }

        public ConfigBuilder setMaxListRows() {
            Integer maxListRows = (Integer)GlobalConfigManagerImpl.this.bandanaManager.getValue((BandanaContext)GlobalConfigManagerImpl.this.confluenceBandanaContext, GlobalConfigManagerImpl.this.getBandanaKey(GlobalConfigManagerImpl.MAX_LIST_ROWS));
            if (maxListRows != null) {
                this.config.setMaxListRows(maxListRows);
            }
            return this;
        }

        public ConfigBuilder setShowHideMap() {
            Map showHideMap = (Map)GlobalConfigManagerImpl.this.bandanaManager.getValue((BandanaContext)GlobalConfigManagerImpl.this.confluenceBandanaContext, GlobalConfigManagerImpl.this.getBandanaKey(GlobalConfigManagerImpl.SHOW_HIDE));
            if (showHideMap == null) {
                showHideMap = Maps.newHashMap();
            }
            if (!TextUtils.stringSet((String)((String)showHideMap.get(GlobalConfigManagerImpl.SHOW_BOARD_SPACES)))) {
                showHideMap.put(GlobalConfigManagerImpl.SHOW_BOARD_SPACES, "ANY");
            }
            if (!TextUtils.stringSet((String)((String)showHideMap.get(GlobalConfigManagerImpl.HIDE_BOARD_SPACES)))) {
                showHideMap.put(GlobalConfigManagerImpl.HIDE_BOARD_SPACES, "NONE");
            }
            if (!TextUtils.stringSet((String)((String)showHideMap.get(GlobalConfigManagerImpl.SHOW_LIST_SPACES)))) {
                showHideMap.put(GlobalConfigManagerImpl.SHOW_LIST_SPACES, "ANY");
            }
            if (!TextUtils.stringSet((String)((String)showHideMap.get(GlobalConfigManagerImpl.HIDE_LIST_SPACES)))) {
                showHideMap.put(GlobalConfigManagerImpl.HIDE_LIST_SPACES, "NONE");
            }
            this.config.setShowHideMap(showHideMap);
            return this;
        }

        public ConfigBuilder setMetadataAccessor() {
            String metadataAccessorType = (String)GlobalConfigManagerImpl.this.bandanaManager.getValue((BandanaContext)GlobalConfigManagerImpl.this.confluenceBandanaContext, GlobalConfigManagerImpl.this.getBandanaKey(GlobalConfigManagerImpl.METADATA_ACCESSOR_NAME));
            if (metadataAccessorType != null) {
                this.config.setMetadataAccessorType(GlobalConfig.MetadataAccessorType.valueOf(metadataAccessorType));
            } else {
                this.config.setMetadataAccessorType(GlobalConfig.MetadataAccessorType.Default);
            }
            return this;
        }

        public GlobalConfig build() {
            return this.config;
        }

        public ConfigBuilder setNotifyOwnActions() {
            Boolean notify = (Boolean)GlobalConfigManagerImpl.this.bandanaManager.getValue((BandanaContext)GlobalConfigManagerImpl.this.confluenceBandanaContext, GlobalConfigManagerImpl.this.getBandanaKey(GlobalConfigManagerImpl.NOTIFY_OWN_ACTIONS));
            this.config.setNotifyOwnChanges(notify == null ? false : notify);
            return this;
        }

        public ConfigBuilder setNoStats() {
            Boolean noStats = (Boolean)GlobalConfigManagerImpl.this.bandanaManager.getValue((BandanaContext)GlobalConfigManagerImpl.this.confluenceBandanaContext, GlobalConfigManagerImpl.this.getBandanaKey(GlobalConfigManagerImpl.NO_STATS));
            this.config.setNoStats(noStats == null ? false : noStats);
            return this;
        }
    }
}

