/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.boards;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.templates.PageTemplate;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.BuildInformation;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.actions.ProfilePictureInfo;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.comalatech.confluence.adhoclists.boards.BoardRenderer;
import com.comalatech.confluence.adhoclists.boards.view.BoardResolver;
import com.comalatech.confluence.adhoclists.boards.view.model.ResolvedBoard;
import com.comalatech.confluence.adhoclists.license.AdhocLicenseManager;
import com.comalatech.confluence.adhoclists.model.Filter;
import com.comalatech.confluence.adhoclists.model.ResolvedFilter;
import com.comalatech.confluence.adhoclists.templates.AdhocTemplateManager;
import com.comalatech.confluence.boards.model.Board;
import com.comalatech.confluence.boards.model.BoardViewContext;
import com.opensymphony.util.TextUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class DefaultBoardRenderer
implements BoardRenderer {
    private static final Logger log = LoggerFactory.getLogger(DefaultBoardRenderer.class);
    public static final String BOARD_TEMPLATE = "/templates/adhoclists/vm/boards/board.vm";
    public static final String BOARD_PREVIEW_TEMPLATE = "/templates/adhoclists/vm/boards/boardpreview.vm";
    public static final String EMBEDDED_BOARD_TEMPLATE = "/templates/adhoclists/vm/boards/embeddedboard.vm";
    protected final BoardResolver labelBoardResolver;
    protected final BoardResolver previewBoardResolver;
    protected final WikiStyleRenderer wikiStyleRenderer;
    protected final PermissionManager permissionManager;
    protected final SpaceManager spaceManager;
    protected final PageManager pageManager;
    protected final AdhocLicenseManager licenseManager;
    private final AdhocTemplateManager adhocTemplateManager;
    private final UserAccessor userAccessor;
    private final PageTemplateManager pageTemplateManager;

    public DefaultBoardRenderer(@Qualifier(value="labelBoardResolver") BoardResolver labelBoardResolver, @Qualifier(value="previewBoardResolver") BoardResolver previewBoardResolver, WikiStyleRenderer wikiStyleRenderer, PermissionManager permissionManager, SpaceManager spaceManager, PageManager pageManager, AdhocTemplateManager adhocTemplateManager, AdhocLicenseManager licenseManager, UserAccessor userAccessor, PageTemplateManager pageTemplateManager) {
        this.labelBoardResolver = labelBoardResolver;
        this.previewBoardResolver = previewBoardResolver;
        this.wikiStyleRenderer = wikiStyleRenderer;
        this.permissionManager = permissionManager;
        this.spaceManager = spaceManager;
        this.pageManager = pageManager;
        this.adhocTemplateManager = adhocTemplateManager;
        this.licenseManager = licenseManager;
        this.userAccessor = userAccessor;
        this.pageTemplateManager = pageTemplateManager;
    }

    @Override
    public String render(BoardViewContext viewContext, Board board, ResolvedFilter filter) {
        BoardResolver boardResolver = this.getBoardResolver(board);
        ResolvedBoard renderedBoard = boardResolver != null ? boardResolver.resolveBoard(viewContext, filter, board) : null;
        return this.renderBoard(viewContext, renderedBoard, filter, false, BOARD_TEMPLATE, "");
    }

    @Override
    public String renderPreview(BoardViewContext viewContext, Board board, ResolvedFilter filter) {
        String description = board.getDescription();
        String descriptionHtml = TextUtils.stringSet((String)description) ? this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)new PageContext(), description) : "";
        viewContext.setPreview(true);
        ResolvedBoard resolvedBoard = this.previewBoardResolver.resolveBoard(viewContext, filter, board);
        return this.renderBoard(viewContext, resolvedBoard, filter, false, BOARD_PREVIEW_TEMPLATE, descriptionHtml);
    }

    @Override
    public String renderEmbedded(BoardViewContext viewContext, Board board, ResolvedFilter filter) {
        BoardResolver boardResolver = this.getBoardResolver(board);
        ResolvedBoard resolvedBoard = boardResolver != null ? boardResolver.resolveBoard(viewContext, filter, board) : null;
        return this.renderBoard(viewContext, resolvedBoard, filter, board.isBoardNotifications(), EMBEDDED_BOARD_TEMPLATE, "");
    }

    private String renderBoard(BoardViewContext viewContext, Object board, Filter filter, boolean notifications, String templateName, String descriptionHtml) {
        Map context = MacroUtils.defaultVelocityContext();
        context.put("board", board);
        context.put("viewContext", viewContext);
        context.put("licenseManager", this.licenseManager);
        context.put("filter", filter);
        context.put("descriptionHtml", descriptionHtml);
        context.put("canAdd", this.canAddPage(viewContext, filter));
        context.put("sendNotifications", notifications);
        context.put("boardRenderer", this);
        context.put("buildInformation", BuildInformation.INSTANCE);
        if (board instanceof ResolvedBoard) {
            String templateNameOrId = ((ResolvedBoard)board).getBoard().getTemplateName();
            if (TextUtils.stringSet((String)templateNameOrId)) {
                try {
                    long id = Long.parseLong(templateNameOrId);
                    PageTemplate template = this.pageTemplateManager.getPageTemplate(id);
                    context.put("newPageTemplateId", template != null ? id : 0L);
                }
                catch (NumberFormatException e) {
                    PageTemplate template = this.adhocTemplateManager.getPageTemplate(viewContext.getSpaceKey(), templateNameOrId);
                    context.put("newPageTemplateId", template != null ? template.getId() : 0L);
                }
            } else {
                context.put("newPageTemplateId", 0L);
            }
        }
        return VelocityUtils.getRenderedTemplate((String)templateName, (Map)context);
    }

    private boolean canAddPage(BoardViewContext viewContext, Filter filter) {
        String spaceKey;
        String string = spaceKey = TextUtils.stringSet((String)filter.getSpaceKey()) ? filter.getSpaceKey() : viewContext.getSpaceKey();
        if (viewContext.getSpaceKey() == null || !viewContext.getSpaceKey().equals(spaceKey)) {
            return false;
        }
        if (this.permissionManager.hasCreatePermission((com.atlassian.user.User)AuthenticatedUserThreadLocal.get(), (Object)this.spaceManager.getSpace(spaceKey), Page.class)) {
            String parent = filter.getParent();
            if (TextUtils.stringSet((String)parent) && !parent.equals("@self")) {
                Page parentPage;
                try {
                    parentPage = this.pageManager.getPage(Long.parseLong(filter.getParent()));
                }
                catch (Exception e) {
                    parentPage = this.pageManager.getPage(spaceKey, filter.getParent());
                }
                return this.permissionManager.hasPermission((com.atlassian.user.User)AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)parentPage);
            }
            return true;
        }
        return false;
    }

    private BoardResolver getBoardResolver(Board board) {
        log.debug("board type 2:" + (Object)((Object)board.getType()));
        if (board.getType() == Board.Type.LABEL) {
            return this.labelBoardResolver;
        }
        return null;
    }

    public User getHeadingUser(String heading) {
        if (heading == null) {
            return null;
        }
        if (!(heading = heading.trim()).startsWith("@") || heading.length() < 3) {
            return null;
        }
        ConfluenceUser user = this.userAccessor.getUserByName(heading.substring(1));
        if (user == null) {
            return null;
        }
        return new User(user);
    }

    public class User {
        String name;
        String fullName;
        String pictureUrl;

        public User(ConfluenceUser user) {
            this.name = user.getName();
            this.fullName = user.getFullName();
            ProfilePictureInfo picture = DefaultBoardRenderer.this.userAccessor.getUserProfilePicture((com.atlassian.user.User)user);
            if (picture != null) {
                this.pictureUrl = picture.getUriReference();
            }
        }

        public String getName() {
            return this.name;
        }

        public String getFullName() {
            return this.fullName;
        }

        public String getPictureUrl() {
            return this.pictureUrl;
        }
    }
}

