/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var Adhoc = Adhoc || {};
Adhoc.Board = Adhoc.Board || {};

(function ($) {

    Adhoc.Board.toJson = function () {
        return JSON.stringify(Adhoc.Board.board);
    };

    Adhoc.Board.setMacroParams = function (macro) {
        Adhoc.Board.macroParams = macro.params || {};
    };

    Adhoc.Board.getMacroParams = function () {
        return Adhoc.Board.macroParams;
    };

    Adhoc.Board.getIdParam = function () {
        var params = Adhoc.Board.getMacroParams();
        var id = params.id || "";
        return id;
    };

    Adhoc.Board.setIfNotDefault = function (object, valueName, value) {
        if (value) {
            if (value == true) {
                object[valueName] = value;
            } else if (value.length > 0) {
                object[valueName] = value.trim();
            }
        }
    };

    Adhoc.Board.update = function () {
        var $board = $(".boarddesigner");

        Adhoc.Board.spaceKey = AJS.params.spaceKey;
        Adhoc.Board.board = {};
        Adhoc.Board.board.type = $board.attr("boardType");
        Adhoc.Board.board.row = [];
        Adhoc.Board.board.name = $("#boardname").val();
        if ($("#boardmaxrows").val() && $("#boardmaxrows").val() > 0) {
            Adhoc.Board.board.maxRows = $("#boardmaxrows").val();
        }
        Adhoc.Board.setIfNotDefault(Adhoc.Board.board, "matchHeight", $("#matchHeight").is(":checked"));
        Adhoc.Board.setIfNotDefault(Adhoc.Board.board, "matchRowHeight", $("#matchRowHeight").is(":checked"));
        Adhoc.Board.setIfNotDefault(Adhoc.Board.board, "leftJustified", $("#boardCentered:checked").length == 0);
        Adhoc.Board.setIfNotDefault(Adhoc.Board.board, "boardNotifications", $("#boardNotifications:checked").length > 0);
        Adhoc.Board.setIfNotDefault(Adhoc.Board.board, "hideDescriptions", $("#hideBoardDescriptions:checked").length > 0);
        Adhoc.Board.setIfNotDefault(Adhoc.Board.board, "templateName", $("#boardTemplateName option:selected").val());
        Adhoc.Board.setIfNotDefault(Adhoc.Board.board, "cardsOnlyBoard", $("#cardsOrPagesOnlyBoard option:selected").val() == "cardsonly");
        Adhoc.Board.setIfNotDefault(Adhoc.Board.board, "pagesOnlyBoard", $("#cardsOrPagesOnlyBoard option:selected").val() == "pagesonly");
        Adhoc.Board.setIfNotDefault(Adhoc.Board.board, "description", $("#boardDescription").val());

        var $cardsOrPagesOnly = $("#cardsOrPagesOnlyBoard option:selected");
        if ($cardsOrPagesOnly.attr("name") == "cardsonly") {
            Adhoc.Board.board.cardsOnlyBoard = true;
        } else if ($cardsOrPagesOnly.attr("name") == "pagesonly") {
            Adhoc.Board.board.pagesOnlyBoard = true;
        }
        $(".boarddesigner .boardrowcontainer").each(function () {
            var row = {};
            Adhoc.Board.setIfNotDefault(row, "header", $("input[name='rowheader']", $(this)).val());
            Adhoc.Board.setIfNotDefault(row, "footer", $("input[name='rowfooter']", $(this)).val());
            row.column = [];
            $(this).find(".columnsrow .boardcolumntd").each(function () {
                var column = {};
                Adhoc.Board.setIfNotDefault(column, "header", $("input[name='columnheader']", $(this)).val());
                Adhoc.Board.setIfNotDefault(column, "footer", $("input[name='columnfooter']", $(this)).val());
                column.container = [];
                $(this).find(".boardcontainer").each(function () {
                    var $container = $(this);
                    var container = {};
                    container.key = $container.attr("containerkey");
                    container.caption = $container.find(".containercaption").text();
                    container.style = $container.attr("containerstyle");
                    if ($(".containercardbody", $container).length > 0) {
                        container.cards = [];
                        $(".containercardbody", $container).each(function () {
                            var cardbody = $(this).text();
                            container.cards.push(cardbody);
                        });
                    }

                    $description = $("textarea.description", $(this));
                    $icon = $("input.cnv-icon", $(this));
                    Adhoc.Board.setIfNotDefault(container, "description", $description.val());
                    Adhoc.Board.setIfNotDefault(container, "icon", $icon.val());

                    column.container.push(container);
                });
                if (column.container.length > 0) {
                    row.column.push(column);
                }
            });
            if (row.column.length > 0) {
                Adhoc.Board.board.row.push(row);
            }
        });
    };

    AJS.toInit(function ($) {
        Adhoc.Board.update();
    });
})(AJS.$);
