/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.boards.macro;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.adhoclists.condition.RestCondition;
import com.comalatech.confluence.adhoclists.license.AdhocLicenseManager;

public abstract class NewConditionalMacro
implements Macro {
    private RestCondition restCondition;
    protected SpaceManager spaceManager;
    private AdhocLicenseManager licenseManager;

    protected NewConditionalMacro(RestCondition restCondition, SpaceManager spaceManager, AdhocLicenseManager licenseManager) {
        this.restCondition = restCondition;
        this.spaceManager = spaceManager;
        this.licenseManager = licenseManager;
    }

    public void checkDisplayPermission(NewConditionalMacro macro, String spaceKey, MacroCondition condition) throws MacroException {
        Space space = this.spaceManager.getSpace(spaceKey);
        boolean shouldDisplay = false;
        if (condition.name().equals(MacroCondition.SHOWBOARD.name())) {
            shouldDisplay = this.restCondition.isBoardsVisible((ConfluenceEntityObject)space);
        }
        if (!shouldDisplay) {
            throw new MacroException(condition.getMessage() + spaceKey);
        }
    }

    public AdhocLicenseManager getLicenseManager() {
        return this.licenseManager;
    }

    public static enum MacroCondition {
        SHOWBOARD("Comala Boards are not enabled in this space : ");

        private String message;

        private MacroCondition(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

