/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.storage.serializer;

import com.comalatech.confluence.adhoclists.model.Table;
import com.comalatech.confluence.adhoclists.storage.serializer.Serializer;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public abstract class TableXmlSerializer<T extends Table>
implements Serializer<T>,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(TableXmlSerializer.class);
    private JAXBContext context;

    public abstract Class[] getClasses();

    @Override
    public String serialize(T table) {
        try {
            Marshaller marshaller = this.context.createMarshaller();
            StringWriter writer = new StringWriter();
            marshaller.marshal(table, (Writer)writer);
            return writer.toString();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    @Override
    public T deserialize(String table) {
        try {
            Unmarshaller unmarshaller = this.context.createUnmarshaller();
            StringReader reader = new StringReader(table);
            return (T)((Table)unmarshaller.unmarshal((Reader)reader));
        }
        catch (JAXBException e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.context = JAXBContext.newInstance((Class[])this.getClasses());
    }
}

