/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.metadata;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.HtmlToXmlConverter;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.confluence.xhtml.api.MacroDefinitionHandler;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.core.util.PairType;
import com.atlassian.renderer.RenderContext;
import com.atlassian.spring.container.ContainerManager;
import com.comalatech.confluence.adhoclists.metadata.MetadataAccessor;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.opensymphony.util.TextUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.DOMReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.tidy.Tidy;

public class TabularMetadataAccessor
implements MetadataAccessor {
    private static final Logger log = LoggerFactory.getLogger(TabularMetadataAccessor.class);
    private static final TabularMetadataAccessor INSTANCE = new TabularMetadataAccessor();
    private XhtmlContent xhtmlContent;
    private HtmlToXmlConverter htmlToXmlConverter;
    public static final String CHARSET_UTF8 = "UTF-8";

    private TabularMetadataAccessor() {
        ContainerManager.autowireComponent((Object)this);
    }

    public static TabularMetadataAccessor getInstance() {
        return INSTANCE;
    }

    @Override
    public String getValue(final AbstractPage page, final String valueName) {
        final ArrayList pairsList = Lists.newArrayList();
        try {
            this.xhtmlContent.handleMacroDefinitions(page.getBodyAsString(), (ConversionContext)new DefaultConversionContext((RenderContext)page.toPageContext()), new MacroDefinitionHandler(){

                public void handle(MacroDefinition macroDefinition) {
                    String bodyText;
                    if ("details".equals(macroDefinition.getName()) && TextUtils.stringSet((String)(bodyText = macroDefinition.getBodyText()))) {
                        try {
                            pairsList.addAll(TabularMetadataAccessor.this.getDetails(bodyText, (ConversionContext)new DefaultConversionContext((RenderContext)page.toPageContext())));
                        }
                        catch (XMLStreamException e) {
                            log.error(e.getMessage());
                        }
                        catch (XhtmlException e) {
                            log.error(e.getMessage());
                        }
                        catch (IOException e) {
                            log.error(e.getMessage());
                        }
                    }
                }
            });
        }
        catch (XhtmlException e) {
            log.error(String.format("cannot process page xhtml of %s:%s", page.getSpaceKey(), page.getTitle()));
        }
        ArrayList matchingPairs = Lists.newArrayList((Iterable)Iterables.filter((Iterable)pairsList, (Predicate)new Predicate<PairType>(){

            public boolean apply(PairType input) {
                return input.getKey().equals(valueName.toLowerCase());
            }
        }));
        return matchingPairs.size() > 0 ? (String)((Object)((PairType)matchingPairs.get(matchingPairs.size() - 1)).getValue()) : "";
    }

    @Override
    public void setValue(AbstractPage page, String valueName, String value) {
        log.error("Tabular Metadata edit not (yet) implemented.");
        throw new RuntimeException("Tabular Metadata edit not (yet) implemented. ");
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    public void setXhtmlContent(XhtmlContent xhtmlContent) {
        this.xhtmlContent = xhtmlContent;
    }

    public void setHtmlToXmlConverter(HtmlToXmlConverter htmlToXmlConverter) {
        this.htmlToXmlConverter = htmlToXmlConverter;
    }

    private List<PairType> getDetails(String macroBodyXhtml, ConversionContext conversionContext) throws XMLStreamException, XhtmlException, IOException {
        ArrayList<PairType> pairTypes = new ArrayList<PairType>();
        String pageHtml = this.xhtmlContent.convertStorageToView(macroBodyXhtml, conversionContext);
        String xml = this.htmlToXmlConverter.convert(pageHtml);
        String macroBodyXhtmlCleaned = "<div>" + xml + "</div>";
        Document macroBodyDoc = this.getMacroBodyDocument(macroBodyXhtmlCleaned);
        Element tableElement = (Element)macroBodyDoc.selectSingleNode("//tbody");
        if (tableElement == null) {
            return pairTypes;
        }
        List rowElements = tableElement.elements("tr");
        if (rowElements == null) {
            return pairTypes;
        }
        return this.loadDetailPairsFromTableRows(rowElements, pairTypes);
    }

    private List<PairType> loadDetailPairsFromTableRows(List<Element> rowElements, List<PairType> pairTypes) throws IOException {
        boolean firstRowIsThs = false;
        ArrayList keyElements = Lists.newArrayList();
        ArrayList valueElements = Lists.newArrayList();
        for (Element rowElem : rowElements) {
            List tds = rowElem.elements("td");
            List ths = rowElem.elements("th");
            if (!tds.isEmpty()) {
                if (firstRowIsThs) {
                    valueElements = Lists.newArrayList((Iterable)tds);
                    break;
                }
                if (!ths.isEmpty()) {
                    keyElements.add((Element)ths.get(0));
                    valueElements.add((Element)tds.get(0));
                    continue;
                }
                keyElements.add((Element)tds.get(0));
                valueElements.add(tds.size() > 1 ? (Element)tds.get(1) : null);
                continue;
            }
            if (ths.isEmpty()) continue;
            keyElements = Lists.newArrayList((Iterable)ths);
            firstRowIsThs = true;
        }
        for (int i = 0; i < keyElements.size(); ++i) {
            Element keyElement = (Element)keyElements.get(i);
            Element valueElement = valueElements.size() > i ? (Element)valueElements.get(i) : null;
            pairTypes.add(new PairType((Serializable)((Object)this.getInnerHtml(keyElement).toLowerCase()), (Serializable)((Object)this.getInnerHtml(valueElement))));
        }
        return pairTypes;
    }

    private String getInnerHtml(Element element) throws IOException {
        if (element == null) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        Iterator it = element.nodeIterator();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            node.write((Writer)stringWriter);
        }
        return ((Object)stringWriter).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document getMacroBodyDocument(String macroBodyXhtmlCleaned) {
        byte[] errorStreamContents;
        Document document;
        ByteArrayOutputStream errorStream = new ByteArrayOutputStream();
        Tidy tidy = new Tidy();
        tidy.setQuiet(true);
        tidy.setErrout(new PrintWriter(errorStream));
        tidy.setInputEncoding(CHARSET_UTF8);
        try {
            document = new DOMReader().read(tidy.parseDOM((InputStream)new ByteArrayInputStream(macroBodyXhtmlCleaned.getBytes(CHARSET_UTF8)), null));
        }
        catch (UnsupportedEncodingException utf8NotSupported) {
            byte[] errorStreamContents2;
            Document document2;
            try {
                log.warn(String.format("Unable to read macro body content. Character set %s not supported.", CHARSET_UTF8), (Throwable)utf8NotSupported);
                document2 = new DOMReader().read(tidy.parseDOM((InputStream)new ByteArrayInputStream(macroBodyXhtmlCleaned.getBytes()), null));
            }
            catch (Throwable throwable) {
                byte[] errorStreamContents3;
                if (log.isWarnEnabled() && (errorStreamContents3 = errorStream.toByteArray()).length > 0) {
                    log.warn(String.format("There were some warnings parsing the specified HTML fragment\n%s", new String(errorStreamContents3)));
                }
                throw throwable;
            }
            if (log.isWarnEnabled() && (errorStreamContents2 = errorStream.toByteArray()).length > 0) {
                log.warn(String.format("There were some warnings parsing the specified HTML fragment\n%s", new String(errorStreamContents2)));
            }
            return document2;
        }
        if (log.isWarnEnabled() && (errorStreamContents = errorStream.toByteArray()).length > 0) {
            log.warn(String.format("There were some warnings parsing the specified HTML fragment\n%s", new String(errorStreamContents)));
        }
        return document;
    }
}

