/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.lists.types;

import com.atlassian.confluence.labels.Label;
import com.comalatech.confluence.adhoclists.lists.model.ChecklistColumn;
import com.comalatech.confluence.adhoclists.lists.model.ChecklistColumnGroup;
import com.comalatech.confluence.adhoclists.lists.model.Column;
import com.comalatech.confluence.adhoclists.lists.model.LabelValueType;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="label")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ChecklistColumn(typeNameKey="adhoclists.checklists.designer.column.label.name", typeHintKey="adhoclists.checklists.designer.column.label.hint", columnGroup=ChecklistColumnGroup.LABELS)
public class LabelColumn
extends Column<LabelValueType> {
    private String labelName;
    private String color;

    public LabelColumn() {
    }

    public LabelColumn(Label label) {
        this(label.getName(), label.getName());
    }

    public LabelColumn(String header, String labelName) {
        super(header);
        this.labelName = labelName;
    }

    public LabelColumn(String header, String labelName, String width, String style, boolean readOnly) {
        super(header, width, style, readOnly);
        this.labelName = labelName;
    }

    public String getLabelName() {
        return this.labelName;
    }

    public Label getLabel() {
        return new Label(this.labelName);
    }

    public void setLabelName(String labelName) {
        this.labelName = labelName;
    }

    @Override
    public LabelValueType getValueType() {
        return new LabelValueType(this.getLabel());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LabelColumn that = (LabelColumn)o;
        return !(this.labelName != null ? !this.labelName.equals(that.labelName) : that.labelName != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.labelName != null ? this.labelName.hashCode() : 0);
        return result;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }
}

