/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.boards.notification;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.jmx.JmxSMTPMailServer;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.TinyUrl;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.ConfluenceUserPreferences;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.user.PersonalInformationManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.core.filters.ServletContextThreadLocal;
import com.atlassian.core.task.MultiQueueTaskManager;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.mail.Email;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.queue.SingleMailQueueItem;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.mywork.model.Notification;
import com.atlassian.mywork.service.NotificationService;
import com.atlassian.user.User;
import com.comalatech.confluence.adhoclists.AdhocListsException;
import com.comalatech.confluence.adhoclists.boards.events.WatcherNotificationSentEvent;
import com.comalatech.confluence.adhoclists.boards.notification.AdhocCanvasNotificationService;
import com.comalatech.confluence.adhoclists.boards.notification.model.AdhocEmail;
import com.comalatech.confluence.adhoclists.mywork.NotificationServiceAccessor;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.MimetypesFileTypeMap;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAdhocCanvasNotificationService
implements AdhocCanvasNotificationService {
    private static final Logger log = LoggerFactory.getLogger(DefaultAdhocCanvasNotificationService.class);
    private final PageManager pageManager;
    private final UserAccessor userAccessor;
    private final FormatSettingsManager formatSettingsManager;
    private final PersonalInformationManager personalInformationManager;
    private final AttachmentManager attachmentManager;
    private final MultiQueueTaskManager taskManager;
    private final PermissionManager permissionManager;
    private final NotificationServiceAccessor notificationServiceAccessor;
    private final LocaleManager localeManager;
    private final EventPublisher eventPublisher;
    private final VelocityHelperService velocityHelperService;
    private static final MimetypesFileTypeMap fileTypeMap = new MimetypesFileTypeMap();

    public DefaultAdhocCanvasNotificationService(PageManager pageManager, UserAccessor userAccessor, FormatSettingsManager formatSettingsManager, PersonalInformationManager personalInformationManager, AttachmentManager attachmentManager, MultiQueueTaskManager taskManager, PermissionManager permissionManager, NotificationServiceAccessor notificationServiceAccessor, LocaleManager localeManager, EventPublisher eventPublisher, VelocityHelperService velocityHelperService) {
        this.pageManager = pageManager;
        this.userAccessor = userAccessor;
        this.formatSettingsManager = formatSettingsManager;
        this.personalInformationManager = personalInformationManager;
        this.attachmentManager = attachmentManager;
        this.taskManager = taskManager;
        this.permissionManager = permissionManager;
        this.notificationServiceAccessor = notificationServiceAccessor;
        this.localeManager = localeManager;
        this.eventPublisher = eventPublisher;
        this.velocityHelperService = velocityHelperService;
    }

    @Override
    public void sendEmail(AdhocEmail emailParams, Set<ConfluenceUser> users) {
        this.sendEmail(emailParams, users, Permission.VIEW);
    }

    @Override
    public void sendEmail(AdhocEmail emailParams, Set<ConfluenceUser> users, Permission permission) {
        if (this.getMailServer() != null) {
            AbstractPage page = this.pageManager.getAbstractPage(emailParams.getEntityId());
            ConfluenceUser user = AuthenticatedUserThreadLocal.get();
            ConfluenceUserPreferences preferences = this.userAccessor.getConfluenceUserPreferences((User)user);
            DateFormatter dateFormatter = preferences.getDateFormatter(this.formatSettingsManager, this.localeManager);
            Map velocityContext = MacroUtils.defaultVelocityContext();
            velocityContext.put("sender", user);
            velocityContext.put("ceo", page);
            velocityContext.put("space", page != null ? page.getSpace() : null);
            velocityContext.put("dateFormatter", dateFormatter);
            velocityContext.put("mode", "email");
            velocityContext.put("user", user);
            String baseUrl = this.getBaseUrl();
            velocityContext.put("baseurl", baseUrl);
            velocityContext.put("tinyUrl", page != null ? baseUrl + "/x/" + new TinyUrl(page.getId()).getIdentifier() : null);
            velocityContext.putAll(emailParams.getContextProperties());
            for (ConfluenceUser recipient : users) {
                if (!permission.equals((Object)Permission.ADMINISTER) ? !this.permissionManager.hasPermission((User)recipient, permission, (Object)page) : !this.permissionManager.hasPermission((User)recipient, permission, (Object)page.getSpace())) continue;
                if (recipient.getName().equals(user.getName()) && !this.userAccessor.getPropertySet(user).getBoolean("confluence.prefs.notify.for.my.own.actions")) continue;
                String receivingUserEmail = recipient.getEmail();
                velocityContext.put("receivingUser", recipient);
                try {
                    if (this.getMailServer() == null) continue;
                    this.sendMail(user, velocityContext, receivingUserEmail, emailParams);
                }
                catch (IOException | MessagingException e) {
                    log.error("Error sending email", e);
                }
            }
        }
    }

    @Override
    public boolean isNotificationServiceAvailable() {
        try {
            this.notificationServiceAccessor.getNotificationService();
            return true;
        }
        catch (ClassNotFoundException e) {
            log.error("cant find mywork notification service", (Throwable)e);
        }
        catch (AdhocListsException e) {
            log.error(e.getMessage());
        }
        return false;
    }

    @Override
    public void sendNotifications(Map<ConfluenceUser, Notification> notifications) {
        try {
            NotificationService service = this.notificationServiceAccessor.getNotificationService();
            for (ConfluenceUser user : notifications.keySet()) {
                log.debug("sending mywork notification to " + user.getName());
                service.createOrUpdate(user.getName(), notifications.get(user));
            }
            this.eventPublisher.publish((Object)new WatcherNotificationSentEvent());
        }
        catch (AdhocListsException | ClassNotFoundException e) {
            log.error("cant find mywork notification service");
        }
    }

    protected SMTPMailServer getMailServer() {
        try {
            return MailFactory.getServerManager().getDefaultSMTPMailServer();
        }
        catch (Exception me) {
            log.error("Error getting mail server", (Throwable)me);
            return null;
        }
    }

    protected String getBaseUrl() {
        String domainName = GeneralUtil.getGlobalSettings().getBaseUrl();
        if (TextUtils.stringSet((String)domainName) && domainName.endsWith("/")) {
            domainName = domainName.substring(0, domainName.length() - 1);
        }
        return domainName;
    }

    private void sendMail(ConfluenceUser user, Map<String, Object> velocityContext, String receivingUserEmail, AdhocEmail emailParams) throws MessagingException, IOException {
        String body = this.velocityHelperService.getRenderedTemplate(emailParams.getTemplateLocation(), velocityContext);
        String subject = emailParams.getSubject();
        Email email = new Email(receivingUserEmail);
        email.setFrom(this.getMailServer().getDefaultFrom());
        email.setFromName(this.getServerFromName(user));
        email.setSubject(subject);
        email.setBody(body);
        email.setMimeType("text/html");
        MimeMultipart multipart = new MimeMultipart("related");
        MimeBodyPart avatarBodyPart = new MimeBodyPart();
        avatarBodyPart.setDataHandler(this.createAvatarDataHandler(user));
        avatarBodyPart.setHeader("Content-ID", "<avatar>");
        multipart.addBodyPart((BodyPart)avatarBodyPart);
        this.addImageToMultiPart(multipart, "page-icon", "/images/icons/docs_16.gif");
        email.setMultipart((Multipart)multipart);
        this.taskManager.addTask("mail", () -> ((SingleMailQueueItem)new SingleMailQueueItem(email)).send());
    }

    private String getServerFromName(ConfluenceUser sendingUser) {
        String from = "${fullname} (Confluence)";
        JmxSMTPMailServer server = (JmxSMTPMailServer)this.getMailServer();
        if (server != null) {
            from = server.getFromName();
        }
        String name = sendingUser != null ? sendingUser.getFullName() : ConfluenceActionSupport.getTextStatic((String)"anonymous.name");
        String emailAddress = sendingUser != null ? sendingUser.getEmail() : "";
        String hostname = sendingUser != null && StringUtils.isNotBlank((String)emailAddress) ? emailAddress.substring(emailAddress.indexOf("@") + 1) : "";
        from = StringUtils.replace((String)StringUtils.defaultString((String)from), (String)"${fullname}", (String)name);
        from = StringUtils.replace((String)from, (String)"${email}", (String)emailAddress);
        from = StringUtils.replace((String)from, (String)"${email.hostname}", (String)hostname);
        return from;
    }

    private void addImageToMultiPart(MimeMultipart multipart, String contentId, String pathToImage) throws MessagingException {
        MimeBodyPart imagePart = new MimeBodyPart();
        imagePart.setDataHandler(new DataHandler(this.createWebResourceDataSource(pathToImage)));
        imagePart.setHeader("Content-ID", "<" + contentId + ">");
        multipart.addBodyPart((BodyPart)imagePart);
    }

    private DataHandler createAvatarDataHandler(ConfluenceUser user) throws IOException {
        PropertySet propertySet = this.userAccessor.getPropertySet(user);
        if (propertySet == null) {
            return this.createWebResourceDataHandler("/images/icons/profilepics/default.png");
        }
        String profilePicture = propertySet.getString("confluence.user.profile.picture");
        if (profilePicture == null) {
            return this.createWebResourceDataHandler("/images/icons/profilepics/default.png");
        }
        if (profilePicture.startsWith("/images/icons/profilepics/")) {
            return this.createWebResourceDataHandler(profilePicture);
        }
        PersonalInformation personalInformation = this.personalInformationManager.getOrCreatePersonalInformation((User)user);
        Attachment a = this.attachmentManager.getAttachment((ContentEntityObject)personalInformation, profilePicture);
        if (a != null) {
            return new DataHandler((DataSource)new ProfileImageDataSource((DataSource)new ByteArrayDataSource(this.attachmentManager.getAttachmentData(a), a.getMediaType())));
        }
        return null;
    }

    private DataHandler createWebResourceDataHandler(String pathToImage) {
        DataSource fileDataSource = this.createWebResourceDataSource(pathToImage);
        return new DataHandler((DataSource)new ProfileImageDataSource(fileDataSource));
    }

    private DataSource createWebResourceDataSource(String pathToImage) {
        ByteArrayDataSource dataSource = null;
        String filename = StringUtils.substringAfterLast((String)pathToImage, (String)"/");
        String mimeType = fileTypeMap.getContentType(filename);
        try {
            dataSource = new ByteArrayDataSource(ServletContextThreadLocal.getContext().getResourceAsStream(pathToImage), mimeType);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return dataSource;
    }

    static {
        try {
            fileTypeMap.addMimeTypes(IOUtils.toString((InputStream)BootstrapManager.class.getResourceAsStream("/mime.types")));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load mime types");
        }
    }

    private static class ProfileImageDataSource
    implements DataSource {
        private final DataSource delegate;

        public ProfileImageDataSource(DataSource delegate) {
            this.delegate = delegate;
        }

        public InputStream getInputStream() throws IOException {
            return this.delegate.getInputStream();
        }

        public OutputStream getOutputStream() throws IOException {
            return this.delegate.getOutputStream();
        }

        public String getContentType() {
            return this.delegate.getContentType();
        }

        public String getName() {
            return "avatar";
        }
    }
}

