/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.action;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessBlocked;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContextPathHolder;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.actions.CreatePageAction;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.actions.SpaceAware;
import com.atlassian.plugin.PluginAccessor;
import java.util.Date;

public final class CanvasCreateAction
extends CreatePageAction
implements SpaceAware {
    private ContextPathHolder contextPathHolder;
    private Space space;
    private String body;
    private String markup;

    @ReadOnlyAccessBlocked
    public String execute() throws Exception {
        this.setTitle(this.makePageTitle(this.getTitle()));
        this.body = "<ac:macro ac:name=\"adhocboard\">\n    <ac:parameter ac:name=\"name\">" + this.getTitle() + "</ac:parameter>\n    <ac:parameter ac:name=\"parent\">@self</ac:parameter>\n    <ac:plain-text-body>" + this.markup + "</ac:plain-text-body>\n</ac:macro>\n";
        return this.doCreateAndView();
    }

    private String makePageTitle(String boardName) throws Exception {
        String formattedDate = this.getDateFormatter().formatGivenString("yyyy-MM-dd", new Date());
        String baseTitle = boardName + " " + formattedDate;
        String title = boardName;
        int i = 0;
        do {
            if (this.pageManager.getPage(this.getSpaceKey(), title) == null) {
                return title;
            }
            title = i > 0 ? baseTitle + " (" + i + ")" : baseTitle;
        } while (++i < 100);
        throw new Exception("Cannot create title name");
    }

    private String doCreateAndView() {
        Page page = new Page();
        page.setTitle(this.getTitle());
        page.setBodyAsString(this.body);
        page.setSpace(this.space);
        Page parent = this.getParentPage();
        if (parent != null) {
            parent.addChild(page);
        }
        this.labelManager.addLabel((Labelable)page, new Label("canvas-board"));
        this.pageManager.saveContentEntity((ContentEntityObject)page, (SaveContext)((DefaultSaveContext.Builder)((DefaultSaveContext.Builder)DefaultSaveContext.builder().suppressNotifications(false)).updateLastModifier(true).suppressEvents(false)).build());
        this.setPage((AbstractPage)page);
        return "success";
    }

    public void setSpace(Space space) {
        this.space = space;
    }

    public boolean isSpaceRequired() {
        return true;
    }

    public void setSpaceKey(String spaceKey) {
        super.setSpaceKey(spaceKey);
        this.setNewSpaceKey(spaceKey);
    }

    public String getFormaction() {
        return this.contextPathHolder.getContextPath() + "/plugins/createcontent/docreatepage.action";
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setContextPathHolder(ContextPathHolder contextPathHolder) {
        this.contextPathHolder = contextPathHolder;
    }

    public void setLabelManager(LabelManager labelManager) {
        this.labelManager = labelManager;
    }

    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public void setMarkup(String markup) {
        this.markup = markup;
    }
}

