/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

Canvas = Canvas || {};
Canvas.View = Canvas.View || {};
Canvas.View.Wizard = Backbone.View.extend({

    className: "dialog-panel-body panel-body cnv-wizard hidden",
    id: "wizard-table",

    initialize: function() {
        var idFormatted = this.options.wizard
                            .replace(" ", "")
                            .toLowerCase();
        this.el.id = "wizard-table-" + idFormatted;

        this.wizard = new Canvas.Wizard[this.options.wizard]();
        this.render();
        this.model = new Canvas.Model.Table();
        this.model.build = this.build;
        this.model.wizard = this.wizard;
        AUI.DialogPanels.addPanel(this.$el);
        this.$markup = this.$(".newtablemarkup");
    },

    build: function() {
        var board = this.wizard.makeBoard();
        if (board) {
            this.set("board",board,{silent: true});
        }
    },

    select: function() {
        AUI.DialogPanels.selectPanel(this.$el);
        Canvas.AppView.setChosenTable(this.model);
        Canvas.AppView.history.navigate('board/wizard/' + this.options.wizard);
    },

    render: function() {
        this.$el.html(this.wizard.$el);
        return this;
    }

});