/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

function CanvasBlueprint(canvasBlueprint,webitem) {
    var blueprint = canvasBlueprint;
    this.wizard = function(createDialog, spaceKey, createFunction) {
        var view = new blueprint();
        var $dialog = AJS.$("#" + createDialog.id);
        var page = createDialog.addPage("cnv-blueprint-dialog " + webitem),
            createHandler = function (dialog) {
                var board = view.makeBoard();
                if (! board) {
                    return;
                }
                var context = {
                    markup: JSON.stringify(board.toJSON())
                };
                var markup = "<![CDATA[" + JSON.stringify(board.toJSON()) + "]]>";
                var form = assembleSubmissionForm(board.get("name"),spaceKey,markup);
                $(document.body).append(form);
                form.submit();
            };
        page.addHeader(AJS.I18n.getText("canvas.blueprint.title.create"))
                .addPanel("SinglePanel", view.$el, "singlePanel")
                .addButton("Back", function (dialog) {
                    dialog.prevPage();
                    dialog.page.pop(); // remove the extra dialog page when we move back.
                }, "hello-blueprint-back-button")
                .addButton("Create", createHandler, "cnv-blueprint-create")
                .addLink("Cancel", function (dialog) {
                    dialog.remove();
                }, "button-panel-cancel-link");
        $dialog.find(".cnv-blueprint-create").removeClass("button-panel-button").addClass("aui-button aui-button-primary"); // Pueblo que fueres, haz lo que vieres

        // help link to Canvas Board Picker doc page
        AJS.$('h2.dialog-title', page.getPage(1).element).prepend(helpLink());    
        
        if (view.show) {
            view.show(createDialog,spaceKey)
        }
    };

    /*
     * Create dialog help link to Canvas Board Picker doc page 
     */
    helpLink = function () {
        var a = AJS.$('<a></a>', {
            href: 'https://apps.appf.re/cbdc/doc/getstarted/cnUeBE',
            target: '_blank',
            "class" : 'cml-help-link'
        }).html('Help');

        help = AJS.$('<div></div>', {
            'class' : 'dialog-help-link'
        }).html(a);

        return help;
    };

    function assembleSubmissionForm(title, spaceKey, markup) {

        var form = $('<form></form>');
        form.attr('method', 'post');

        form.attr('action', Confluence.getContextPath() + '/plugins/adhoccanvas/create.action');
        form.append(createHiddenField('markup', markup));
        form.append(createHiddenField('spaceKey', spaceKey));
        form.append(createHiddenField('title', title || ''));
        form.append(createHiddenField('atl_token', Confluence.getXsrfToken()));
        form.append(createHiddenField('parentPageId', Confluence.getContentId()));

        return form;
    };

    function createHiddenField(name, value) {
        var field = $('<input>');
        field.attr('name', name);
        field.attr('value', value);
        field.attr('type', 'hidden');
        return field;
    };

    Confluence.Blueprint.register("com.comalatech.adhoccanvas:" + webitem,this.wizard);
}

(function ($) {
    new CanvasBlueprint(Canvas.Wizard.TasksBoard,"canvas-blueprint-tasks-webitem-adg3");
    new CanvasBlueprint(Canvas.PickerBlueprint,"canvas-blueprint-picker-webitem-adg3");
})(AJS.$);


