/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.lists;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.persistence.dao.LabelSearchResult;
import com.atlassian.confluence.security.PermissionManager;
import com.comalatech.confluence.adhoclists.AbstractTableCreator;
import com.comalatech.confluence.adhoclists.lists.ChecklistCreator;
import com.comalatech.confluence.adhoclists.lists.model.Checklist;
import com.comalatech.confluence.adhoclists.lists.model.PageValueType;
import com.comalatech.confluence.adhoclists.lists.types.LabelColumn;
import com.comalatech.confluence.adhoclists.lists.types.PageColumn;
import java.util.List;

public class DefaultChecklistCreator
extends AbstractTableCreator
implements ChecklistCreator {
    private static final int MAX_POPULAR_LABELS = 10;
    private LabelManager labelManager;

    public DefaultChecklistCreator(LabelManager labelManager, PermissionManager permissionManager) {
        super(permissionManager);
        this.labelManager = labelManager;
    }

    @Override
    public Checklist createPopularLabelsChecklist(String spaceKey) {
        List popularLabels = this.labelManager.getMostPopularLabelsInSpace(spaceKey, 10);
        Checklist checklist = new Checklist(ConfluenceActionSupport.getTextStatic((String)"adhoclists.checklists.space.default.labels"));
        checklist.addColumn(new PageColumn(PageValueType.Type.VIEWLINK));
        checklist.addColumn(new PageColumn(PageValueType.Type.CREATOR));
        checklist.addColumn(new PageColumn(PageValueType.Type.CREATIONDATE));
        checklist.setLeftJustified(true);
        for (LabelSearchResult label : popularLabels) {
            checklist.addColumn(new LabelColumn(label.getLabel()));
        }
        return checklist;
    }
}

