/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.boards;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.comalatech.confluence.adhoclists.AbstractTableHandler;
import com.comalatech.confluence.adhoclists.AdhocListsException;
import com.comalatech.confluence.adhoclists.boards.BoardHandler;
import com.comalatech.confluence.adhoclists.boards.BoardValidator;
import com.comalatech.confluence.adhoclists.boards.events.CardMovedOnBoardEvent;
import com.comalatech.confluence.adhoclists.boards.view.model.RenderedCard;
import com.comalatech.confluence.adhoclists.cards.CardManager;
import com.comalatech.confluence.adhoclists.cards.model.Card;
import com.comalatech.confluence.adhoclists.cards.model.Cards;
import com.comalatech.confluence.adhoclists.cards.model.ResolvedCard;
import com.comalatech.confluence.adhoclists.exceptions.InvalidLabelException;
import com.comalatech.confluence.adhoclists.exceptions.InvalidParentException;
import com.comalatech.confluence.boards.model.Board;
import com.comalatech.confluence.boards.model.Container;
import com.comalatech.confluence.boards.model.LabelContainer;
import com.opensymphony.util.TextUtils;
import java.util.List;
import java.util.Map;

public class DefaultBoardHandler
extends AbstractTableHandler
implements BoardHandler {
    private LabelManager labelManager;
    private BoardValidator boardValidator;
    private CardManager cardManager;
    private EventPublisher eventPublisher;
    private WikiStyleRenderer wikiStyleRenderer;

    public DefaultBoardHandler(PageManager pageManager, LabelManager labelManager, BoardValidator boardValidator, CardManager cardManager, EventPublisher eventPublisher, WikiStyleRenderer wikiStyleRenderer) {
        super(pageManager);
        this.labelManager = labelManager;
        this.boardValidator = boardValidator;
        this.cardManager = cardManager;
        this.eventPublisher = eventPublisher;
        this.wikiStyleRenderer = wikiStyleRenderer;
    }

    @Override
    public void move(ContentEntityObject containingObject, Page page, String from, String fromFilter, String fromTitle, String fromColour, String to, String toFilter, String toTitle, String toColour, Card nextCard, boolean isNotify) throws AdhocListsException {
        this.validateLabels(from, fromFilter, to, toFilter);
        this.moveLabels(page, from, fromFilter, to, toFilter);
        this.cardManager.moveCard(containingObject, new Card(page.getIdAsString(), null), from, to, nextCard);
        ResolvedCard resolvedCard = new ResolvedCard(page.getIdAsString(), page.getTitle(), null);
        this.publishCardMoved(containingObject, from, fromTitle, fromColour, to, toTitle, toColour, isNotify, resolvedCard);
    }

    @Override
    public void move(ContentEntityObject containingObject, String body, String from, String fromTitle, String fromColour, String to, String toTitle, String toColour, Card nextCard, boolean isNotify) throws AdhocListsException {
        this.validateLabels(from, to);
        Card card = new Card(null, body);
        this.cardManager.moveCard(containingObject, card, from, to, nextCard);
        ResolvedCard resolvedCard = new ResolvedCard(card.getBody());
        this.publishCardMoved(containingObject, from, fromTitle, fromColour, to, toTitle, toColour, isNotify, resolvedCard);
    }

    private void publishCardMoved(ContentEntityObject containingObject, String fromKey, String fromTitle, String fromColour, String toKey, String toTitle, String toColour, boolean isNotify, ResolvedCard card) {
        CardMovedOnBoardEvent event = new CardMovedOnBoardEvent(card, containingObject, fromKey, fromTitle, fromColour, toKey, toTitle, toColour, Board.Type.LABEL, isNotify);
        this.eventPublisher.publish((Object)event);
    }

    @Override
    public void remove(ContentEntityObject containingObject, String key, Card card) throws AdhocListsException {
        if (card.getId() != null) {
            Page page = this.getPage(card.getId());
            this.moveLabels(page, key, null);
        }
        this.cardManager.moveCard(containingObject, card, key, null, null);
    }

    @Override
    public void removeCards(ContentEntityObject ceo, Map[] data) {
        if (data != null) {
            for (Map containerData : data) {
                if (containerData == null || !containerData.containsKey("container")) continue;
                this.cardManager.removeCards(ceo, (String)containerData.get("container"));
            }
        }
    }

    @Override
    public RenderedCard updateCard(ContentEntityObject containingObject, String key, Card card, String newbody) throws AdhocListsException {
        try {
            ResolvedCard newCard = new ResolvedCard(newbody);
            if (!newCard.equals(card)) {
                Cards cards = this.cardManager.getCards(containingObject, key);
                if (cards.get(new Card(null, newbody)) != null) {
                    throw new AdhocListsException(ConfluenceActionSupport.getTextStatic((String)"adhoccanvas.exceptions.board.cardexists.msg", (Object[])new Object[]{newbody}));
                }
                this.cardManager.updateCard(containingObject, card, key, newbody);
            }
            RenderedCard renderedCard = new RenderedCard(newCard);
            renderedCard.setBodyHtml(this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)containingObject.toPageContext(), renderedCard.getBody()));
            return renderedCard;
        }
        catch (IllegalArgumentException e) {
            throw new AdhocListsException(e.getMessage());
        }
    }

    private Page getPage(String id) throws AdhocListsException {
        try {
            long pid = Long.parseLong(id);
            Page page = this.pageManager.getPage(pid);
            if (page == null) {
                throw new Exception();
            }
            return page;
        }
        catch (Exception e) {
            throw new AdhocListsException("Invalid pageId " + id);
        }
    }

    private void moveLabels(Page page, String from, String to) throws AdhocListsException {
        this.validateLabels(from, to);
        if (TextUtils.stringSet((String)from)) {
            for (Label fromLabel : new LabelContainer(new Container(from)).getPageLabelList()) {
                this.labelManager.removeLabel((Labelable)page, fromLabel);
            }
        }
        if (TextUtils.stringSet((String)to)) {
            List existingLabels = page.getLabels();
            for (Label toLabel : new LabelContainer(new Container(to)).getPageLabelList()) {
                if (existingLabels.contains(toLabel)) continue;
                this.labelManager.addLabel((Labelable)page, toLabel);
            }
        }
    }

    private void moveLabels(Page page, String from, String fromFilter, String to, String toFilter) throws AdhocListsException {
        StringBuilder combinedFrom = new StringBuilder();
        StringBuilder combinedTo = new StringBuilder();
        if (TextUtils.stringSet((String)from)) {
            combinedFrom.append(from).append(",");
        }
        if (TextUtils.stringSet((String)to)) {
            combinedTo.append(to).append(",");
        }
        if (TextUtils.stringSet((String)fromFilter)) {
            combinedFrom.append(fromFilter);
        }
        if (TextUtils.stringSet((String)toFilter)) {
            combinedTo.append(toFilter);
        }
        this.moveLabels(page, combinedFrom.toString(), combinedTo.toString());
    }

    private void validateLabels(String ... labels) throws InvalidLabelException {
        for (String label : labels) {
            if (label == null || this.boardValidator.isValidLabels(label)) continue;
            throw new InvalidLabelException("Invalid Label ", label);
        }
    }

    @Override
    public RenderedCard addCard(AbstractPage page, String containerId, String toContainerTitle, String color, Card card, boolean isNotify) {
        this.cardManager.addCard((ContentEntityObject)page, card, containerId);
        RenderedCard renderedCard = new RenderedCard(new ResolvedCard(card.getBody()));
        renderedCard.setBodyHtml(this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)page.toPageContext(), card.getBody()));
        this.publishCardMoved((ContentEntityObject)page, null, null, null, containerId, toContainerTitle, color, isNotify, renderedCard);
        return renderedCard;
    }

    @Override
    public RenderedCard addPage(Board.Type type, Space currentSpace, String pageSpaceKey, String title, String wikiBody, String containerId, String filterKey, String toContainerTitle, String color, Page parent, AbstractPage containingPage, boolean isNotify) throws AdhocListsException {
        ResolvedCard card;
        this.validateLabels(containerId, filterKey);
        Page page = this.pageManager.getPage(pageSpaceKey, title);
        if (page == null) {
            if (parent == null && containingPage instanceof Page) {
                parent = (Page)containingPage;
            }
            page = this.createPageWikiBody(currentSpace, title, wikiBody, parent);
            this.addLabels(type, containerId, page);
            this.addLabels(type, filterKey, page);
            card = new ResolvedCard(page.getIdAsString(), page.getTitle(), page.getUrlPath());
        } else {
            if (currentSpace.getKey().equalsIgnoreCase(pageSpaceKey) && parent != null && (page.getParent() == null || !page.getAncestors().contains(parent))) {
                String message = ConfluenceActionSupport.getTextStatic((String)"adhoccanvas.exceptions.board.invalidparentexception.msg", (Object[])new String[]{page.getTitle(), parent.getTitle()});
                throw new InvalidParentException(message);
            }
            card = new ResolvedCard(page.getIdAsString(), page.getTitle(), page.getUrlPath());
            this.addLabels(type, containerId, page);
            this.addLabels(type, filterKey, page);
        }
        this.cardManager.addCard((ContentEntityObject)containingPage, card, containerId);
        this.publishCardMoved((ContentEntityObject)containingPage, null, null, null, containerId, toContainerTitle, color, isNotify, card);
        return new RenderedCard(card);
    }

    private void addLabels(Board.Type type, String containerId, Page page) {
        if (TextUtils.stringSet((String)containerId) && type == Board.Type.LABEL) {
            List<Label> labels = new LabelContainer(new Container(containerId)).getPageLabelList();
            for (Label label : labels) {
                this.labelManager.addLabel((Labelable)page, label);
            }
        }
    }
}

