/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var Canvas = Canvas || {};
Canvas.Model = Canvas.Model || {};
Canvas.Model.Container = Backbone.Model.extend({

    clone: function() {
        return new Canvas.Model.Container(_.clone(this.attributes));
    }
});

Canvas.Collection = Canvas.Collection || {};
Canvas.Collection.Containers = Backbone.Collection.extend({
    model: Canvas.Model.Container,

    clone: function() {
        var containers = new Canvas.Collection.Containers();
        this.each(function(container) {
            containers.add(container.clone());
        },this);
        return containers;
    }
});

Canvas.Model.Column = Backbone.Model.extend({

    initialize: function() {
        Canvas.unsetDefaultValues(this);
    },

    toJSON: function() {
        return _.extend(_.clone(this.attributes), {container:this.get("container").toJSON()});
    },

    clone: function() {
        return new Canvas.Model.Column(_.extend(_.clone(this.attributes),{container: this.get("container").clone()}))
    }
});

Canvas.Collection.Columns = Backbone.Collection.extend({
    model: Canvas.Model.Column,

    clone: function() {
        var columns = new Canvas.Collection.Columns();
        this.each(function(column) {
            columns.add(column.clone());
        },this);
        return columns;
    }
});

Canvas.Model.Row = Backbone.Model.extend({

    initialize: function() {
        Canvas.unsetDefaultValues(this);
    },

    toJSON: function() {
        return _.extend(_.clone(this.attributes),{column: this.get("column").toJSON()});
    },

    clone: function() {
        return new Canvas.Model.Row(_.extend(_.clone(this.attributes),{column: this.get("column").clone()}));
    },

    /**
     * returns an array of Column objects
     * @return {*}
     */
    columns: function() {
        return this.get("column").models;
    }

});

Canvas.Collection.Rows = Backbone.Collection.extend({
    model: Canvas.Model.Row
});

Canvas.Model.Board = Backbone.Model.extend({

    initialize: function() {
        this.bind("change",this.unsetDefaultValues,this);
        var rows = new Canvas.Collection.Rows();
        _.each(this.get("row"),function(row) {
            var columns = new Canvas.Collection.Columns();
            _.each(row.column,function(column){
                var containers = new Canvas.Collection.Containers();
                _.each(column.container,function(container) {
                    containers.add(new Canvas.Model.Container(container));
                },this);
                column = _.extend(_.clone(column), {container: containers});
                columns.add(new Canvas.Model.Column(column));
            },this);
            row = _.extend(_.clone(row),{column: columns});
            rows.add(new Canvas.Model.Row(row));
        },this);
        this.set({row:rows},{silent: true});
        Canvas.unsetDefaultValues(this);
    },

    toJSON: function() {
        var copy = _.clone(this.attributes);
        return _.extend(copy,{row: this.get("row").toJSON()});
    },

    /**
     * Returns an array of Row objects
     * @return {*}
     */
    rows: function() {
        return this.get("row").models;
    },


    unsetDefaultValues: function() {
        Canvas.unsetDefaultValues(this);
    }
});

Canvas.unsetIfDefault =  function(model, attributeName) {
    if (model.get(attributeName) == undefined || model.get(attributeName) == false || model.get(attributeName).length == 0) {
        model.unset(attributeName,{silent: true});
    }
};

Canvas.unsetDefaultValues = function(model) {
    _.each(_.keys(model.attributes),function(attributeName) {
        Canvas.unsetIfDefault(model,attributeName);
    });

};