/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

(function ($) {
    if (Canvas.initialized("page.column")) {
        return;
    }

    AJS.toInit(function ($) {
        AJS.log("init page.column");
        $(document).on('change', "#column-page-type", function(event) {
            event.preventDefault();
            $("#column-header").val($("#column-page-type option:selected").text());
            $("#column-header").change();
        });
        $(document).on('click', "form.aui.checklist.column.page .accept", function(event) {
            event.preventDefault();
            var $form = $(this).parents("form.aui.checklist");
            var columnInfo = $form.getColumnInfo();
            columnInfo.setAttributes($form);
            columnInfo.resetHeading();
            // let's set the column's specific properties
            columnInfo.column[columnInfo.type].type = $("#column-page-type option:selected").val();
            Adhoc.debug = columnInfo;
            Adhoc.Checklist.columnDialog.hide();
            Adhoc.Checklist.refresh();
        });
    });
})(AJS.$);