/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

(function ($) {
    if (Canvas.initialized("label.cell")) {
        return;
    }

    AJS.toInit(function ($) {
        AJS.log("init label.cell");
        $(document).on('click', ".adhocchecklist.view .value-label:not(.readonly)", function() {
            var action;
            var sortValue;
            var $cellValue = $(this);
            if ($cellValue.hasClass("active")) {
                action = "remove";
                sortValue = "0";
            } else {
                action = "add";
                sortValue = "1";
            }
            var label = $cellValue.attr("label");
            if (Adhoc.Checklist.empty($cellValue)) {
                $cellValue.toggleClass("active");
            } else {
                $.ajax({
                    type: "POST",
                    cache: false,
                    contentType: "application/json",
                    url: AJS.Confluence.getContextPath() + "/rest/adhoclists/latest/lists/label/" +
                            Adhoc.Checklist.rowId($cellValue) +
                            "/" + action + "?label=" + encodeURIComponent(label),
                    success: function (action, textStatus, jqXHR) {
                        $cellValue.toggleClass("active");
                        $(".sortvalue",$cellValue.parents(".cell-label")).html(sortValue);
                        $(".adhocchecklist.view").trigger("update");
                        var row = $cellValue.parents("tr.page");
                        row.toggleClass(label + "_label");
                    },
                    error: function(jqXHR, textStatus, errorThrown) {
                        Adhoc.common.errorHandler($cellValue.parents("tr.page"),jqXHR, textStatus,errorThrown);
                    }
                });
            }
        });

        $(document).on('resetcell', "tr.newpagerow td.cell-label", function(event) {
            $(".value-label",$(this)).removeClass("active");
        });
        $(document).on('initcell', "tr.newpagerow td.cell-label", function(event,$newrow) {
            var $cell = $(this);
            var $newCell = $("td:nth-child(" + $cell.attr("index") + ")",$newrow);
            if ($(".value-label",$cell).hasClass("active")) {
                $(".value-label",$newCell).click();
            }
        });
    });
})(AJS.$);