/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

// Class that handles rendering the board picker iframe
// Inside Confluence's own Create Dialog
define(
    'blueprint-picker',
    ['cb', 'jquery', 'underscore'],
    function (CB, $, _) {
        return function(id, url) {
            this.init = function (createDialog, spaceKey) {
                this.dialog = createDialog;
                this.$dialog = $('#' + this.dialog.id);
                this.spaceKey = spaceKey;
                this.pageId = this.dialog.getParentPageId();
                this.width = this.dialog.width;
                this.height = this.dialog.height;
                this.open();
            };
            this.open = function () {
                this.iframe = new CB.iframe({
                    id: CB.format('board-{0}-picker', id),
                    width: "100%",
                    height: "100%",
                    url: CB.format(url, this.spaceKey + (this.pageId ? '/' + this.pageId : ''))
                });
                this.$dialog.append(this.iframe.render());
                this.dialog.popup.changeSize(this.width, 550);
                this.$dialog.find('.dialog-components').hide();
                this.$dialog.append(this.iframe.render());
            };
            this.reset = function () {
                this.iframe.remove();
                this.dialog.popup.changeSize(this.width, this.height);
                this.$dialog.find('.dialog-components').show();
            };
            this.cancel = function (data, source) {
                if (this.iframe) {
                    var $iframe = this.iframe.$iframe;
                    if (source && $iframe && $iframe.get(0) === source.frameElement) {
                        this.reset();
                        this.dialog.prevPage();
                    }
                }
            };
            this.close = function (data, source) {
                if(this.iframe) {
                    var $iframe = this.iframe.$iframe;
                    if (source && $iframe && $iframe.get(0) === source.frameElement) {
                        this.reset();
                        this.dialog.closeDialog();
                    }
                }
            };
            _.bindAll(this, 'init', 'open', 'reset', 'cancel', 'close');
            CB.connect('cancelCreateBoard', this.cancel);
            CB.connect('closeCreateDialog', this.close);
            CB.connect('fullScreen', _.bind(function(isFullScreen) {
                if (this.dialog) {
                    this.dialog.popup.changeSize(
                        isFullScreen ? $(window).width() - 50 : this.width,
                        isFullScreen ? $(window).height() - 50 : 550
                    );
                }
            }, this));
            return this.init;
        };
    }
);