/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.boards.rest;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.user.User;
import com.comalatech.confluence.adhoclists.boards.BoardValidator;
import com.comalatech.confluence.adhoclists.condition.RestCondition;
import com.comalatech.confluence.adhoclists.model.Table;
import com.comalatech.confluence.adhoclists.rest.PermissionRequired;
import com.comalatech.confluence.boards.exception.ComalaBoardsException;
import com.comalatech.confluence.boards.exception.ComalaBoardsRestException;
import com.comalatech.confluence.boards.rest.model.RestError;
import java.lang.reflect.Method;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NewAbstractRestResources<T extends Table> {
    private static final Logger log = LoggerFactory.getLogger(NewAbstractRestResources.class);
    protected final PageManager pageManager;
    protected final SpaceManager spaceManager;
    protected final PermissionManager permissionManager;
    protected final BoardValidator boardValidator;
    protected final RestCondition restCondition;
    protected final I18nResolver i18nResolver;

    public NewAbstractRestResources(PageManager pageManager, SpaceManager spaceManager, PermissionManager permissionManager, I18nResolver i18nResolver, RestCondition restCondition, BoardValidator boardValidator) {
        this.pageManager = pageManager;
        this.spaceManager = spaceManager;
        this.permissionManager = permissionManager;
        this.i18nResolver = i18nResolver;
        this.restCondition = restCondition;
        this.boardValidator = boardValidator;
    }

    private void checkPermissions(AbstractRestCommand command, ConfluenceEntityObject ceo) {
        PermissionRequired.Type[] permissionTypes;
        Method enclosingMethod = command.getClass().getEnclosingMethod();
        if (enclosingMethod == null) {
            throw new ComalaBoardsException("command must be anonymous class");
        }
        PermissionRequired annotation = enclosingMethod.getAnnotation(PermissionRequired.class);
        if (annotation == null) {
            throw new ComalaBoardsRestException(Response.Status.FORBIDDEN.getStatusCode(), "Requested resource does not have the required permissions set");
        }
        for (PermissionRequired.Type type : permissionTypes = annotation.permissionTypes()) {
            if (type == PermissionRequired.Type.CREATEPAGE) {
                if (!(ceo instanceof Space) || this.permissionManager.hasCreatePermission((User)AuthenticatedUserThreadLocal.get(), (Object)ceo, Page.class)) continue;
                throw new ComalaBoardsRestException(type.getHttpErrorCode(), type.getMessage());
            }
            if (type == PermissionRequired.Type.SHOWBOARD) {
                if (this.restCondition.isBoardsVisible(ceo)) continue;
                throw new ComalaBoardsRestException(type.getHttpErrorCode(), type.getMessage());
            }
            this.checkPermission(ceo, type);
        }
    }

    protected void checkPermission(ConfluenceEntityObject ceo, PermissionRequired.Type type) {
        if (!this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), type.getPermission(), (Object)ceo)) {
            throw new ComalaBoardsRestException(type.getHttpErrorCode(), type.getMessage());
        }
    }

    public abstract class AbstractPageRestCommand
    extends AbstractRestCommand {
        private long abstractPageId;

        protected abstract Response doInCommand(AbstractPage var1);

        @Override
        protected Response doInCommand() {
            return this.doInCommand(this.getAbstractPage(this.abstractPageId));
        }

        public Response execute(long abstractPageId) {
            this.abstractPageId = abstractPageId;
            return this.execute();
        }
    }

    public abstract class SpaceRestCommand
    extends AbstractRestCommand {
        private String spaceKey;

        protected abstract Response doInCommand(Space var1);

        @Override
        protected Response doInCommand() {
            return this.doInCommand(this.getSpace(this.spaceKey));
        }

        public Response execute(String spaceKey) {
            this.spaceKey = spaceKey;
            return this.doInCommand();
        }

        protected Space getSpace(String spaceKey) {
            Space space = NewAbstractRestResources.this.spaceManager.getSpace(spaceKey);
            if (space == null) {
                throw new ComalaBoardsRestException(400, "Space with key \"" + spaceKey + "\" not found.");
            }
            NewAbstractRestResources.this.checkPermissions(this, (ConfluenceEntityObject)space);
            return space;
        }
    }

    public abstract class AbstractRestCommand {
        protected AbstractPage getAbstractPage(long abstractPageId) {
            AbstractPage page = NewAbstractRestResources.this.pageManager.getAbstractPage(abstractPageId);
            if (page == null) {
                throw new ComalaBoardsRestException(Response.Status.BAD_REQUEST.getStatusCode(), "No Content Entity found for id=" + abstractPageId);
            }
            NewAbstractRestResources.this.checkPermissions(this, (ConfluenceEntityObject)page);
            return page;
        }

        protected abstract Response doInCommand();

        protected Response execute() {
            try {
                return this.doInCommand();
            }
            catch (ComalaBoardsRestException e) {
                log.error(e.getMessage(), e.getCause() != null ? e.getCause() : e);
                RestError restError = new RestError(e.getStatus(), e.getMessage());
                return Response.status((int)e.getStatus()).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)restError).build();
            }
            catch (ComalaBoardsException e) {
                RestError restError = new RestError(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), e.getMessage());
                log.error(e.getMessage(), e.getCause() != null ? e.getCause() : e);
                return Response.serverError().type(MediaType.APPLICATION_JSON_TYPE).entity((Object)restError).build();
            }
            catch (Error | Exception e) {
                RestError restError = new RestError(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Unexpected error handling the request");
                log.error(e.getMessage(), e);
                return Response.serverError().type(MediaType.APPLICATION_JSON_TYPE).entity((Object)restError).build();
            }
        }
    }
}

