/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoclists.utils;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.Namespace;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.persistence.dao.compatibility.FindUserHelper;
import com.atlassian.spring.container.ContainerManager;
import com.comalatech.confluence.adhoclists.model.GlobalConfig;
import com.comalatech.confluence.adhoclists.module.GlobalConfigManager;
import com.comalatech.confluence.boards.util.BoardUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdhocListsUtils {
    private static final Logger log = LoggerFactory.getLogger(AdhocListsUtils.class);
    private static final String MAX_PAGE_RESULTS_PROPERTY = "com.comalatech.adhoclists.boards.page.maxresults";
    public static final int CQL_QUERY_PAGE_SIZE = 500;
    public static final int MAXIMUM_ROWS_LIMIT = 100;
    public static final int MAXIMUM_ROWS_NO_LICENSE = 20;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static int retrieveMaximumRowsForBoard(GlobalConfigManager globalConfigManager, String macroMaxValue, boolean isLicensed) {
        return AdhocListsUtils.retrieveMaximumRowsForMacro(globalConfigManager, macroMaxValue, isLicensed, true);
    }

    public static int retrieveMaximumRowsForList(GlobalConfigManager globalConfigManager, String macroMaxValue, boolean isLicensed) {
        return AdhocListsUtils.retrieveMaximumRowsForMacro(globalConfigManager, macroMaxValue, isLicensed, false);
    }

    private static int retrieveMaximumRowsForMacro(GlobalConfigManager globalConfigManager, String macroMaxValue, boolean isLicensed, boolean isBoard) {
        int max;
        int macroGlobalMaxValue;
        GlobalConfig globalConfig = globalConfigManager.loadGlobalConfig();
        int n = macroGlobalMaxValue = isBoard ? globalConfig.getMaxBoardRows() : globalConfig.getMaxListRows();
        if (TextUtils.stringSet((String)macroMaxValue)) {
            try {
                max = Integer.parseInt(macroMaxValue);
                if (max <= 0) {
                    max = macroGlobalMaxValue;
                } else if (max > 100) {
                    max = 100;
                }
            }
            catch (NumberFormatException e) {
                log.error("Can't read max rows for canvas macro " + e.getMessage());
                max = macroGlobalMaxValue;
            }
        } else {
            max = !isLicensed ? 20 : macroGlobalMaxValue;
        }
        return max;
    }

    public static String makeId(String str) {
        char[] chars = str.toCharArray();
        StringBuilder id = new StringBuilder();
        boolean first = true;
        for (char aChar : chars) {
            if (first) {
                if (!Character.isLetter(aChar)) continue;
                id.append(aChar);
                first = false;
                continue;
            }
            if (!Character.isLetterOrDigit(aChar)) continue;
            id.append(aChar);
        }
        if (id.length() == 0) {
            id.append("id").append(str.hashCode());
        }
        return id.toString();
    }

    public static String clean(String str) {
        if (!TextUtils.stringSet((String)str)) {
            return "";
        }
        return str.replace('\u00a0', ' ').trim();
    }

    public static List<String> toLabelNameList(String list) {
        if (TextUtils.stringSet((String)list)) {
            HashSet labelsNameList = Sets.newHashSet((Object[])list.split("[\\s,]+"));
            while (labelsNameList.contains("")) {
                labelsNameList.remove("");
            }
            return Lists.newArrayList((Iterable)labelsNameList);
        }
        return Collections.EMPTY_LIST;
    }

    public static List<Label> toLabelList(String commaSeparatedLabels) {
        return AdhocListsUtils.toLabelList(AdhocListsUtils.toLabelNameList(commaSeparatedLabels));
    }

    public static Set<String> keysToLabels(Collection<String> keys) {
        HashSet<String> labels = new HashSet<String>();
        for (String key : keys) {
            labels.addAll(Arrays.asList(AdhocListsUtils.splitAndTrim(key)));
        }
        return labels;
    }

    public static List<Label> toLabelList(Collection<String> labelsNames) {
        ArrayList<Label> labels = new ArrayList<Label>();
        for (String labelName : labelsNames) {
            Label label = labelName.startsWith("@") ? AdhocListsUtils.makeLabelFromUserName(labelName) : new Label(labelName);
            labels.add(label);
        }
        return labels;
    }

    private static Label makeLabelFromUserName(String labelName) {
        String userName = labelName.substring(1);
        String userKey = null;
        ConfluenceUser user = AdhocListsUtils.getUserAccessor().getUserByName(userName);
        if (user != null && user.getKey() != null) {
            userKey = user.getKey().getStringValue();
        }
        if (userKey != null) {
            return new Label(BoardUtils.getPersonalPageLabelFromUsername(userName), Namespace.PERSONAL, FindUserHelper.getUserByUsername((String)userName));
        }
        return new Label(userName);
    }

    public static int getSystemMaxPageResults() {
        String maxResults = System.getProperty(MAX_PAGE_RESULTS_PROPERTY, "100000");
        return Integer.parseInt(maxResults);
    }

    private static UserAccessor getUserAccessor() {
        return (UserAccessor)ContainerManager.getComponent((String)"userAccessor");
    }

    public static String[] splitAndTrim(String str) {
        if (!TextUtils.stringSet((String)str)) {
            return EMPTY_STRING_ARRAY;
        }
        String[] values = str.split(",");
        for (int i = 0; i < values.length; ++i) {
            values[i] = values[i].trim();
        }
        return values;
    }

    public static String[] appendToList(String[] list, String newElement) {
        if (list != null && list.length != 0) {
            Object[] temp = new String[list.length];
            System.arraycopy(list, 0, temp, 0, temp.length);
            Arrays.sort(temp);
            newElement = newElement.trim();
            if (Arrays.binarySearch(temp, newElement) >= 0) {
                return list;
            }
            temp = new String[temp.length + 1];
            System.arraycopy(list, 0, temp, 0, list.length);
            temp[list.length] = newElement;
            Arrays.sort(temp);
            return temp;
        }
        return new String[]{newElement};
    }

    public static String listToString(String[] list) {
        if (list != null && list.length != 0) {
            StringBuilder sb = new StringBuilder();
            String separator = "";
            for (String s : list) {
                sb.append(separator).append(s);
                separator = ",";
            }
            return sb.toString();
        }
        return "";
    }
}

